/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.User;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DatabaseAction {
    private final User user;
    private final Ownable ownable;
    private final Type type;
    private final long timeStamp;
    private final int hashCode;

    public static DatabaseAction newUnownInstance(Ownable ownable) {
        if (ownable == null) {
            throw new NullPointerException("Ownable to unown must be specified");
        }
        return new DatabaseAction(Type.UNOWN, ownable, null);
    }

    public static DatabaseAction newOwnInstance(Ownable ownable, User user) {
        if (user == null) {
            throw new NullPointerException("User to own for must be specified");
        }
        if (user.isNobody()) {
            throw new IllegalArgumentException("User to own for can't be nobody");
        }
        if (ownable == null) {
            throw new NullPointerException("Ownable to own must be specified");
        }
        return new DatabaseAction(Type.OWN, ownable, user);
    }

    public static DatabaseAction newDropInstance(User user) {
        if (user == null) {
            throw new NullPointerException("User to drop can't be null");
        }
        if (user.isNobody()) {
            throw new IllegalArgumentException("User to drop can't be nobody");
        }
        return new DatabaseAction(Type.DROP, null, user);
    }

    private DatabaseAction(Type type, Ownable ownable, User user) {
        this.user = user;
        this.ownable = ownable;
        this.type = type;
        this.timeStamp = System.currentTimeMillis();
        this.hashCode = this.calcHashCode();
    }

    public User getUser() {
        return this.user;
    }

    public Ownable getOwnable() {
        return this.ownable;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Type getActionType() {
        return this.type;
    }

    private int calcHashCode() {
        int prime = 31;
        int result = 3;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.ownable == null ? 0 : this.ownable.hashCode());
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DatabaseAction)) {
            return false;
        }
        DatabaseAction other = (DatabaseAction)obj;
        if (this.type != other.type) {
            return false;
        }
        if (this.ownable == null ? other.ownable != null : !this.ownable.equals(other.ownable)) {
            return false;
        }
        if (Long.compare(this.timeStamp, other.timeStamp) != 0) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        return "DatabaseAction [user=" + this.user + ", ownable=" + this.ownable + ", type=" + (Object)((Object)this.type) + ", timeStamp=" + new SimpleDateFormat().format(new Date(this.timeStamp)) + "]";
    }

    public static enum Type {
        DROP,
        OWN,
        UNOWN;

    }
}

