/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.command.CommandExecutor;
import de.pheasn.blockown.protection.ProtectAction;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CE_UnprotectPlayer
extends CommandExecutor {
    public CE_UnprotectPlayer(BlockOwn plugin) {
        super(plugin);
    }

    @Override
    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        if (!sender.hasPermission(Permission.ADMIN_UNPROTECTPLAYER.toString())) {
            this.plugin.getOutput().sendMessage(sender, Message.COMMAND_NO_PERMISSION);
            return true;
        }
        if (args.length == 1) {
            OfflinePlayer op = this.plugin.getServer().getOfflinePlayer(args[0]);
            if (op.hasPlayedBefore() || op.isOnline()) {
                User user = User.getInstance(op.getUniqueId());
                ProtectAction protectAction = new ProtectAction.Builder(user).drop().build();
                this.plugin.getProtection().enqueue(protectAction);
                this.plugin.getOutput().sendMessage(sender, Message.COMMAND_UNPROTECTPLAYER_SUCCESS, op.getName());
                return true;
            }
            this.plugin.getOutput().sendMessage(sender, Message.COMMAND_INVALID_PLAYER, args[0]);
            return false;
        }
        return false;
    }

    @Override
    protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
        return false;
    }
}

