/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.InvalidWorldException;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.command.CommandExecutor;
import de.pheasn.blockown.protection.ProtectAction;
import java.util.Set;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CE_Unprotect
extends CommandExecutor {
    private static final String PARAM_ENTITY = "e";
    private static final String PARAM_BLOCK = "b";

    public CE_Unprotect(BlockOwn plugin) {
        super(plugin);
    }

    @Override
    protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
        if (!player.hasPermission(Permission.PROTECTION_UNPROTECT.toString())) {
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_PERMISSION);
            return true;
        }
        if (args.length == 1) {
            User user = User.getInstance(player.getUniqueId());
            if (args[0].equalsIgnoreCase(PARAM_ENTITY)) {
                if (this.plugin.isWaiting(user, WaitType.UNPROTECT_ENTITY)) {
                    this.plugin.removeWaiting(user);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                } else {
                    this.plugin.addWaiting(user, WaitType.UNPROTECT_ENTITY);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNPROTECT_CLICK_ENTITY);
                }
                return true;
            }
            if (args[0].equalsIgnoreCase(PARAM_BLOCK)) {
                if (this.plugin.isWaiting(user, WaitType.UNPROTECT_BLOCK)) {
                    this.plugin.removeWaiting(user);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                } else {
                    this.plugin.addWaiting(user, WaitType.UNPROTECT_BLOCK);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNPROTECT_CLICK_BLOCK);
                }
                return true;
            }
            try {
                Material material = Material.parseMaterial(args[0]);
                ProtectAction protectAction = new ProtectAction.Builder(user).unprotect(material).build();
                this.plugin.getProtection().enqueue(protectAction);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNPROTECT_SUCCESS, material.getName());
                return true;
            }
            catch (IllegalArgumentException e) {
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_INVALID_MATERIAL, args[0]);
                return false;
            }
        }
        if (args.length == 0) {
            Block targetBlock = player.getTargetBlock((Set)null, 20);
            if (targetBlock != null) {
                try {
                    Material material = OwnedBlock.newInstance(targetBlock).getMaterial();
                    User user = User.getInstance(player.getUniqueId());
                    ProtectAction protectAction = new ProtectAction.Builder(user).unprotect(material).build();
                    this.plugin.getProtection().enqueue(protectAction);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNPROTECT_SUCCESS, material.getName());
                    return true;
                }
                catch (InvalidWorldException e) {
                    this.plugin.getOutput().printError("This should never happen! CE_UNPROTECT", e);
                    return false;
                }
            }
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NOTARGET);
            return false;
        }
        return false;
    }
}

