/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.command.CommandExecutor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CE_Owning
extends CommandExecutor {
    private static final String PARAM_ON = "on";
    private static final String PARAM_OFF = "off";

    public CE_Owning(BlockOwn plugin) {
        super(plugin);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
        boolean turnOn;
        if (!player.hasPermission(Permission.OWN_SWITCH_OWNING.toString())) {
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_PERMISSION);
            return true;
        }
        User user = User.getInstance(player.getUniqueId());
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase(PARAM_ON)) {
                turnOn = true;
            } else {
                if (!args[0].equalsIgnoreCase(PARAM_OFF)) return false;
                turnOn = false;
            }
        } else {
            if (args.length != 0) return false;
            turnOn = !this.plugin.isOwning(user);
        }
        this.plugin.setOwning(user, turnOn);
        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_OWNING_SUCCESS, turnOn ? PARAM_ON : PARAM_OFF);
        return true;
    }
}

