/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.InvalidWorldException;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.Ownable;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class User
implements Serializable {
    private static final long serialVersionUID = -9170381319637300740L;
    public static final User nobody = new User(null, null);
    private static final Map<UUID, User> users = new WeakHashMap<UUID, User>(128);
    private static BlockOwn plugin = null;
    private final UUID id;
    private transient WeakReference<OfflinePlayer> playerRef = new WeakReference<Object>(null);

    public static User getInstance(UUID id) {
        return User.getInstance(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static User getInstance(UUID id, OfflinePlayer player) {
        if (id == null) {
            throw new NullPointerException("UUID can't be null");
        }
        Map<UUID, User> map = users;
        synchronized (map) {
            User user = users.get(id);
            if (user == null) {
                user = new User(id, player);
                users.put(id, user);
            } else {
                user.playerRef = new WeakReference<OfflinePlayer>(player);
            }
            return user;
        }
    }

    private User(UUID id, OfflinePlayer player) {
        this.id = id;
        this.playerRef = new WeakReference<OfflinePlayer>(player);
    }

    static synchronized void initialize(BlockOwn plugin) {
        if (plugin == null) {
            throw new NullPointerException("Can't initialize with plugin = null");
        }
        User.plugin = plugin;
    }

    public UUID getId() {
        return this.id;
    }

    public boolean isOnline() {
        OfflinePlayer o = this.getOfflinePlayer();
        return o != null && o.isOnline();
    }

    public boolean isOp() {
        OfflinePlayer o = this.getOfflinePlayer();
        return o != null && o.isOp();
    }

    public String getName() {
        OfflinePlayer o = this.getOfflinePlayer();
        return o == null ? null : o.getName();
    }

    public OfflinePlayer getOfflinePlayer() {
        OfflinePlayer offlinePlayer;
        if (this.isNobody()) {
            return null;
        }
        if (this.playerRef == null) {
            this.playerRef = new WeakReference<Object>(null);
        }
        if ((offlinePlayer = (OfflinePlayer)this.playerRef.get()) == null) {
            try {
                offlinePlayer = this.getPlugin().getServer().getOfflinePlayer(this.id);
                this.playerRef = new WeakReference<OfflinePlayer>(offlinePlayer);
            }
            catch (NullPointerException e) {
                return null;
            }
        }
        return offlinePlayer;
    }

    public World getWorld() {
        OfflinePlayer offlinePlayer = this.getOfflinePlayer();
        if (offlinePlayer == null) {
            return null;
        }
        Player player = offlinePlayer.getPlayer();
        if (player == null) {
            return null;
        }
        return player.getWorld();
    }

    public boolean isNobody() {
        return this.id == null;
    }

    private BlockOwn getPlugin() {
        if (plugin == null) {
            User.initialize((BlockOwn)Bukkit.getPluginManager().getPlugin("BlockOwn"));
        }
        return plugin;
    }

    public boolean hasAccess(Ownable ownable) throws InvalidWorldException {
        User owner = this.getPlugin().getOwningDatabase().getOwner(ownable);
        return owner.isNobody() || this.hasAccess(ownable.getMaterial(), owner);
    }

    public boolean hasAccess(Material material, User owner) {
        return this.getPlugin().getProtection().hasAccess(owner, material, this);
    }

    public boolean hasProtected(Material material) {
        return this.getPlugin().getProtection().isProtected(this, material);
    }

    public boolean hasLocked(Material material) {
        return this.getPlugin().getProtection().isLocked(this, material);
    }

    public boolean hasFriend(User user) {
        return this.getPlugin().getProtection().isFriend(this, user);
    }

    public boolean isIgnoring() {
        return this.getPlugin().isIgnoring(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 5;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        String name = this.getName();
        return name == null ? (this.id == null ? "nobody" : this.id.toString()) : name;
    }
}

