/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.InvalidUUIDException;
import de.pheasn.blockown.InvalidWorldException;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.Ownable;
import java.lang.ref.WeakReference;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class OwnedEntity
implements Ownable {
    private static final long serialVersionUID = -5197934920645104143L;
    private transient WeakReference<Entity> entityRef = new WeakReference<Object>(null);
    private final UUID id;
    private final String worldName;
    private transient Material material = null;

    public static OwnedEntity newInstance(Entity entity) {
        if (entity == null) {
            throw new NullPointerException("Entity can't be null");
        }
        return new OwnedEntity(entity.getUniqueId(), entity.getWorld().getName(), new Material(entity.getType()), entity);
    }

    public static OwnedEntity newInstance(UUID id, String worldName, Material material) {
        if (id == null) {
            throw new NullPointerException("UUID can't be null");
        }
        if (worldName == null) {
            throw new NullPointerException("world name can't be null");
        }
        return new OwnedEntity(id, worldName, material, null);
    }

    public static OwnedEntity newInstance(UUID id, String worldName) {
        return OwnedEntity.newInstance(id, worldName, null);
    }

    private OwnedEntity(UUID id, String worldName, Material material, Entity entity) {
        this.id = id;
        this.worldName = worldName;
        this.material = material;
        this.entityRef = new WeakReference<Entity>(entity);
    }

    public Entity getEntity() throws InvalidWorldException, InvalidUUIDException {
        Entity result;
        if (this.entityRef == null) {
            this.entityRef = new WeakReference<Object>(null);
        }
        if ((result = (Entity)this.entityRef.get()) == null) {
            for (Entity entity : this.getWorld().getEntitiesByClass(this.material.getEntityType().getEntityClass())) {
                if (!entity.getUniqueId().equals(this.id)) continue;
                this.entityRef = new WeakReference<Entity>(entity);
                return entity;
            }
            throw new InvalidUUIDException("No entity with UUID " + this.id + " could be found in world " + this.worldName);
        }
        return result;
    }

    public UUID getUniqueId() {
        return this.id;
    }

    @Override
    public World getWorld() throws InvalidWorldException {
        World world = Bukkit.getServer().getWorld(this.worldName);
        if (world == null) {
            throw new InvalidWorldException("There is no world called " + this.worldName);
        }
        return world;
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public Material getMaterial() throws InvalidWorldException {
        if (this.material == null) {
            this.material = new Material(this.getEntity().getType());
        }
        return this.material;
    }

    public boolean isLiving() throws InvalidWorldException, InvalidUUIDException {
        EntityType type = this.getMaterial().getEntityType();
        return type.isAlive();
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OwnedEntity)) {
            return false;
        }
        OwnedEntity other = (OwnedEntity)obj;
        return this.id.equals(other.id);
    }

    public String toString() {
        return "OwnedEntity [id=" + this.id + ", worldName=" + this.worldName + ", material=" + this.material + "]";
    }
}

