/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.InvalidWorldException;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.Ownable;
import java.lang.ref.WeakReference;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;

public class OwnedBlock
implements Ownable {
    private static final long serialVersionUID = 4996349639615230112L;
    private transient WeakReference<Block> blockRef = new WeakReference<Object>(null);
    private final int hashCode;
    private final String worldName;
    private final int x;
    private final int y;
    private final int z;
    private transient Material material = null;

    public static OwnedBlock newInstance(Block block) {
        if (block == null) {
            throw new NullPointerException("Block can't be null");
        }
        return new OwnedBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ(), new Material(block.getType()), block);
    }

    public static OwnedBlock newInstance(String worldName, int x, int y, int z, Material material) {
        if (worldName == null) {
            throw new NullPointerException("world name can't be null");
        }
        return new OwnedBlock(worldName, x, y, z, material, null);
    }

    public static OwnedBlock newInstance(String worldName, int x, int y, int z) {
        return OwnedBlock.newInstance(worldName, x, y, z, null);
    }

    private OwnedBlock(String worldName, int x, int y, int z, Material material, Block block) {
        this.worldName = worldName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.material = material;
        this.blockRef = new WeakReference<Block>(block);
        this.hashCode = this.calcHashCode();
    }

    private int calcHashCode() {
        int prime = 31;
        int result = 13;
        result = 31 * result + this.worldName.hashCode();
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    @Override
    public World getWorld() throws InvalidWorldException {
        World world = Bukkit.getServer().getWorld(this.worldName);
        if (world == null) {
            throw new InvalidWorldException("There is no world called " + this.worldName);
        }
        return world;
    }

    public Block getBlock() throws InvalidWorldException {
        Block result;
        if (this.blockRef == null) {
            this.blockRef = new WeakReference<Object>(null);
        }
        if ((result = (Block)this.blockRef.get()) == null) {
            result = this.getWorld().getBlockAt(this.x, this.y, this.z);
            this.blockRef = new WeakReference<Block>(result);
        }
        return result;
    }

    @Override
    public String getWorldName() {
        return this.worldName;
    }

    @Override
    public Material getMaterial() throws InvalidWorldException {
        if (this.material == null) {
            this.material = new Material(this.getBlock().getType());
        }
        return this.material;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OwnedBlock)) {
            return false;
        }
        OwnedBlock other = (OwnedBlock)obj;
        if (!this.worldName.equals(other.worldName)) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return "OwnedBlock [block=" + this.getWorldName() + ":" + this.getX() + "," + this.getY() + "," + this.getZ() + "]";
    }
}

