/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.Message;
import de.pheasn.blockown.Output;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DefaultOutput
implements Output {
    private final Logger logger;

    DefaultOutput() {
        Plugin plugin = Bukkit.getPluginManager().getPlugin("BlockOwn");
        this.logger = plugin.getLogger();
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public void printError(Throwable e) {
        this.getLogger().log(Level.SEVERE, "Exception in BlockOwn", e);
    }

    @Override
    public void printError(String message) {
        this.getLogger().log(Level.SEVERE, message);
    }

    @Override
    public void printError(String message, Throwable e) {
        this.getLogger().log(Level.SEVERE, message, e);
    }

    @Override
    public void printException(Throwable e) {
        this.getLogger().log(Level.WARNING, "[non-fatal] Exception in BlockOwn");
    }

    @Override
    public void printException(String message) {
        this.getLogger().log(Level.WARNING, "[non-fatal] " + message);
    }

    @Override
    public void printException(String message, Throwable e) {
        this.getLogger().log(Level.WARNING, "[non-fatal] " + message);
    }

    @Override
    public void printConsole(Message message) {
        this.getLogger().log(Level.INFO, message.toString());
    }

    @Override
    public void printConsole(String message) {
        this.getLogger().log(Level.INFO, message);
    }

    @Override
    public void sendMessage(CommandSender sender, Message message) {
        if (message.toString().isEmpty()) {
            return;
        }
        if (sender instanceof Player) {
            sender.sendMessage(message.toString());
        } else {
            this.printConsole(message);
        }
    }

    @Override
    public void sendMessage(CommandSender sender, Message message, Object ... params) {
        if (message.toString().isEmpty()) {
            return;
        }
        String messageString = MessageFormat.format(message.toString(), params);
        if (sender instanceof Player) {
            sender.sendMessage(messageString);
        } else {
            this.printConsole(messageString);
        }
    }

    @Override
    public void broadcast(Message message) {
        this.printConsole(message);
        for (World world : Bukkit.getServer().getWorlds()) {
            this.broadcastInWorld(world, message);
        }
    }

    @Override
    public void broadcast(World world, Message message) {
        this.printConsole(message);
        this.broadcastInWorld(world, message);
    }

    private void broadcastInWorld(World world, Message message) {
        for (Player player : world.getPlayers()) {
            player.sendMessage(message.toString());
        }
    }

    @Override
    public void debugMessage(String message) {
        this.getLogger().log(Level.FINE, message);
    }
}

