/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.protection;

import de.pheasn.blockown.Material;
import de.pheasn.blockown.Output;
import de.pheasn.blockown.Setting;
import de.pheasn.blockown.User;
import de.pheasn.blockown.protection.ProtectAction;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.bukkit.Bukkit;
import org.bukkit.entity.Animals;
import org.bukkit.entity.LivingEntity;

public class Protection
implements Runnable {
    private final Object LOCK = new Object();
    private volatile boolean disable = false;
    private final Output output;
    private final File protectionFile;
    private final int initialUserCapacity;
    private final int initialMaterialCapacity = 50;
    private final Map<User, Set<Material>> protections;
    private final Map<User, Set<Material>> locks;
    private final Map<User, Set<User>> friends;
    protected final ConcurrentLinkedQueue<ProtectAction> queue;
    private final Set<Material> allowedMaterials;
    private final Set<Material> disallowedMaterials;
    private final Set<Material> autoProtectedMaterials;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Protection(Output output, File protectionFile) throws IOException {
        int initialCapacity;
        this.output = output;
        this.protectionFile = protectionFile;
        this.queue = new ConcurrentLinkedQueue();
        this.allowedMaterials = this.getAllowedMaterials();
        this.disallowedMaterials = this.getDisallowedMaterials();
        this.autoProtectedMaterials = this.getAutoProtectedMaterials();
        try {
            initialCapacity = Bukkit.getOfflinePlayers().length * 2;
        }
        catch (NullPointerException e) {
            initialCapacity = 0;
        }
        if (initialCapacity == 0) {
            initialCapacity = 50;
        }
        this.initialUserCapacity = initialCapacity;
        if (this.getProtectionFile().exists()) {
            Map loadedProtections = null;
            Map loadedLocks = null;
            Map loadedFriends = null;
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.getProtectionFile()));
            try {
                Object o = ois.readObject();
                assert (o instanceof HashMap);
                loadedProtections = (Map)o;
                o = ois.readObject();
                assert (o instanceof HashMap);
                loadedLocks = (Map)o;
                o = ois.readObject();
                assert (o instanceof HashMap);
                loadedFriends = (Map)o;
                ois.close();
            }
            catch (EOFException | StreamCorruptedException | ClassNotFoundException e) {
                this.getOutput().printError("Corrupted protection file. All manually protected / locked materials are lost.", e);
                ois.close();
                File corruptFile = new File(this.getProtectionFile().getParentFile(), "protection.dat.corrupt");
                if (corruptFile.exists() && !corruptFile.delete() || !this.getProtectionFile().renameTo(corruptFile)) {
                    this.getOutput().printConsole("Protection file couldn't be deleted. Please delete the 'protection.dat' file manually");
                }
                loadedProtections = loadedProtections != null ? loadedProtections : new HashMap(this.initialUserCapacity);
                loadedLocks = loadedLocks != null ? loadedLocks : new HashMap(this.initialUserCapacity);
                loadedFriends = loadedFriends != null ? loadedFriends : new HashMap(this.initialUserCapacity);
            }
            finally {
                this.protections = loadedProtections;
                this.locks = loadedLocks;
                this.friends = loadedFriends;
            }
        } else {
            this.protections = new HashMap<User, Set<Material>>(this.initialUserCapacity);
            this.locks = new HashMap<User, Set<Material>>(this.initialUserCapacity);
            this.friends = new HashMap<User, Set<User>>(this.initialUserCapacity);
        }
    }

    private Output getOutput() {
        return this.output;
    }

    private File getProtectionFile() {
        return this.protectionFile;
    }

    private Set<Material> getAllowedMaterials() {
        List<String> allowed = Setting.PROTECTION_ALLOWED_MATERIALS.get();
        HashSet<Material> result = new HashSet<Material>(allowed.size(), 1.0f);
        for (String materialName : allowed) {
            try {
                Material m = Material.parseMaterial(materialName);
                result.add(m);
            }
            catch (IllegalArgumentException ignored) {}
        }
        return result;
    }

    private Set<Material> getDisallowedMaterials() {
        List<String> disallowed = Setting.PROTECTION_DISALLOWED_MATERIALS.get();
        HashSet<Material> result = new HashSet<Material>(disallowed.size(), 1.0f);
        for (String materialName : disallowed) {
            try {
                Material m = Material.parseMaterial(materialName);
                result.add(m);
            }
            catch (IllegalArgumentException ignored) {}
        }
        return result;
    }

    private Set<Material> getAutoProtectedMaterials() {
        List<String> autoProtected = Setting.PROTECTION_AUTO_PROTECT_MATERIALS.get();
        HashSet<Material> result = new HashSet<Material>(autoProtected.size(), 1.0f);
        for (String materialName : autoProtected) {
            Material m = Material.parseMaterial(materialName);
            if (m == null) continue;
            result.add(m);
        }
        return result;
    }

    private void save() {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.getProtectionFile(), false));
            oos.writeObject(this.protections);
            oos.writeObject(this.locks);
            oos.writeObject(this.friends);
            oos.close();
        }
        catch (IOException e) {
            this.getOutput().printError("Error while saving protection file", e);
        }
    }

    private void doAction(ProtectAction protectAction) {
        switch (protectAction.getActionType()) {
            case PROTECT: {
                this.protect(protectAction.getOwner(), protectAction.getMaterial());
                return;
            }
            case UNPROTECT: {
                this.unprotect(protectAction.getOwner(), protectAction.getMaterial());
                return;
            }
            case LOCK: {
                this.lock(protectAction.getOwner(), protectAction.getMaterial());
                return;
            }
            case UNLOCK: {
                this.unlock(protectAction.getOwner(), protectAction.getMaterial());
                return;
            }
            case FRIEND: {
                this.friend(protectAction.getOwner(), protectAction.getUser());
                return;
            }
            case UNFRIEND: {
                this.unfriend(protectAction.getOwner(), protectAction.getUser());
                return;
            }
            case DROP: {
                this.dropUserData(protectAction.getOwner());
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    private void dropUserData(User user) {
        this.protections.remove(user);
        this.locks.remove(user);
        this.friends.remove(user);
        for (Set<User> list : this.friends.values()) {
            list.remove(user);
        }
    }

    private void protect(User owner, Material material) {
        if (this.protections.get(owner) == null) {
            this.protections.put(owner, new HashSet(50));
        }
        this.protections.get(owner).add(material);
    }

    private void unprotect(User owner, Material material) {
        if (this.protections.get(owner) == null) {
            this.protections.put(owner, new HashSet(50));
        }
        this.protections.get(owner).remove(material);
    }

    private void lock(User owner, Material material) {
        if (this.locks.get(owner) == null) {
            this.locks.put(owner, new HashSet(50));
        }
        this.locks.get(owner).add(material);
    }

    private void unlock(User owner, Material material) {
        if (this.locks.get(owner) == null) {
            this.locks.put(owner, new HashSet(50));
        }
        this.locks.get(owner).remove(material);
    }

    private void friend(User owner, User user) {
        if (this.friends.get(owner) == null) {
            this.friends.put(owner, new HashSet(this.initialUserCapacity));
        }
        this.friends.get(owner).add(user);
    }

    private void unfriend(User owner, User user) {
        if (this.friends.get(owner) == null) {
            this.friends.put(owner, new HashSet(this.initialUserCapacity));
        }
        this.friends.get(owner).remove(user);
    }

    private boolean isAllowed(Material material) {
        if (material.isAny()) {
            return true;
        }
        if (this.disallowedMaterials.contains(material)) {
            return false;
        }
        return this.allowedMaterials.isEmpty() || this.allowedMaterials.contains(material);
    }

    private boolean isAutoProtected(Material material) {
        if (this.autoProtectedMaterials.contains(material)) {
            return true;
        }
        if (this.autoProtectedMaterials.contains(Material.ANY)) {
            return true;
        }
        if (!material.isBlock()) {
            if (Animals.class.isAssignableFrom(material.getEntityType().getEntityClass())) {
                return Setting.PROTECTION_AUTO_PROTECT_OWNED_ANIMALS.get();
            }
            if (!LivingEntity.class.isAssignableFrom(material.getEntityType().getEntityClass())) {
                return Setting.PROTECTION_AUTO_PROTECT_OWNED_ENTITIES.get();
            }
            return false;
        }
        return Setting.PROTECTION_AUTO_PROTECT_OWNED_BLOCKS.get();
    }

    public boolean hasAccess(User owner, Material material, User user) {
        if (!this.isAllowed(material)) {
            return true;
        }
        if (this.isListLocked(owner, material)) {
            return false;
        }
        if (this.isFriend(owner, user)) {
            return true;
        }
        if (this.isAutoProtected(material)) {
            return false;
        }
        return !this.isListProtected(owner, material);
    }

    private boolean isListLocked(User owner, Material material) {
        Set<Material> lockList = this.locks.get(owner);
        if (lockList == null) {
            return false;
        }
        if (lockList.contains(material)) {
            return true;
        }
        return lockList.contains(Material.ANY);
    }

    public boolean isLocked(User owner, Material material) {
        if (!this.isAllowed(material)) {
            return false;
        }
        return this.isListLocked(owner, material);
    }

    public boolean isFriend(User owner, User user) {
        Set<User> friendList = this.friends.get(owner);
        if (friendList == null) {
            return false;
        }
        return friendList.contains(user);
    }

    private boolean isListProtected(User owner, Material material) {
        Set<Material> protectionList = this.protections.get(owner);
        if (protectionList == null) {
            return false;
        }
        if (protectionList.contains(material)) {
            return true;
        }
        return protectionList.contains(Material.ANY);
    }

    public boolean isProtected(User owner, Material material) {
        if (!this.isAllowed(material)) {
            return false;
        }
        if (this.isAutoProtected(material)) {
            return true;
        }
        return this.isListProtected(owner, material);
    }

    public Set<User> getFriends(User owner) {
        Set<User> result = this.friends.get(owner);
        if (result == null) {
            result = new HashSet<User>();
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<Material> getLocks(User owner) {
        Set<Material> result = this.locks.get(owner);
        if (result == null) {
            result = new HashSet<Material>();
        }
        return Collections.unmodifiableSet(result);
    }

    public Set<Material> getProtections(User owner) {
        Set<Material> result = this.protections.get(owner);
        if (result == null) {
            result = new HashSet<Material>();
        }
        return Collections.unmodifiableSet(result);
    }

    public final Thread enqueue(final ProtectAction protectAction) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                Protection.this.syncedEnqueue(protectAction);
            }
        }, "ProtectionEnqueueThread");
        t.start();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void syncedEnqueue(ProtectAction protectAction) {
        this.queue.add(protectAction);
        Object object = this.LOCK;
        synchronized (object) {
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Object object = this.LOCK;
        synchronized (object) {
            this.disable = true;
            this.LOCK.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.disable || !this.queue.isEmpty()) {
            if (!this.queue.isEmpty()) {
                ProtectAction protectAction = (ProtectAction)this.queue.remove();
                this.doAction(protectAction);
                continue;
            }
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    while (!this.disable && this.queue.isEmpty()) {
                        this.LOCK.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                this.getOutput().printException("Database thread has been interrupted.", e);
            }
        }
        this.save();
    }
}

