/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.protection;

import de.pheasn.blockown.AbstractBuilder;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.User;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ProtectAction {
    private final Type type;
    private final User owner;
    private final User user;
    private final Material material;
    private final long timeStamp;

    private ProtectAction(Type type, User owner, Material material, User user) {
        switch (type) {
            case DROP: {
                break;
            }
            case FRIEND: 
            case UNFRIEND: {
                if (user == null) {
                    throw new NullPointerException("User can't be null");
                }
                if (!user.isNobody()) break;
                throw new IllegalArgumentException("User can't be nobody");
            }
            case LOCK: 
            case UNLOCK: 
            case PROTECT: 
            case UNPROTECT: {
                if (material != null) break;
                throw new NullPointerException("Material can't be null");
            }
            default: {
                throw new IllegalArgumentException("Invalid ProtectAction.Type");
            }
        }
        if (owner == null) {
            throw new NullPointerException("Owner can't be null");
        }
        if (owner.isNobody()) {
            throw new IllegalArgumentException("Owner can't be nobody");
        }
        this.type = type;
        this.owner = owner;
        this.material = material;
        this.user = user;
        this.timeStamp = System.currentTimeMillis();
    }

    public Type getActionType() {
        return this.type;
    }

    public User getOwner() {
        return this.owner;
    }

    public User getUser() {
        return this.user;
    }

    public Material getMaterial() {
        return this.material;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public int hashCode() {
        int prime = 31;
        int result = 17;
        result = 31 * result + (this.material == null ? 0 : this.material.hashCode());
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtectAction)) {
            return false;
        }
        ProtectAction other = (ProtectAction)obj;
        if (this.material == null ? other.material != null : !this.material.equals(other.material)) {
            return false;
        }
        if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        if (this.timeStamp != other.timeStamp) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        return "ProtectAction [protectActionType=" + (Object)((Object)this.type) + ", owner=" + this.owner + ", user=" + this.user + ", material=" + this.material + ", timeStamp=" + new SimpleDateFormat().format(new Date(this.timeStamp)) + "]";
    }

    public static class Builder
    extends AbstractBuilder<ProtectAction> {
        private Type type;
        private User owner;
        private Material material;
        private User user;

        public Builder(User owner) {
            this.owner = owner;
        }

        public Builder protect(Material material) {
            this.material = material;
            this.type = Type.PROTECT;
            return this;
        }

        public Builder unprotect(Material material) {
            this.material = material;
            this.type = Type.UNPROTECT;
            return this;
        }

        public Builder lock(Material material) {
            this.material = material;
            this.type = Type.LOCK;
            return this;
        }

        public Builder unlock(Material material) {
            this.material = material;
            this.type = Type.UNLOCK;
            return this;
        }

        public Builder friend(User user) {
            this.user = user;
            this.type = Type.FRIEND;
            return this;
        }

        public Builder unfriend(User user) {
            this.user = user;
            this.type = Type.UNFRIEND;
            return this;
        }

        public Builder drop() {
            this.type = Type.DROP;
            return this;
        }

        @Override
        public ProtectAction build() {
            return new ProtectAction(this.type, this.owner, this.material, this.user);
        }
    }

    public static enum Type {
        PROTECT,
        UNPROTECT,
        LOCK,
        UNLOCK,
        FRIEND,
        UNFRIEND,
        DROP;

    }
}

