/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.importer;

import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.Setting;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.MySqlDatabase;
import de.pheasn.blockown.importer.Importer;
import de.pheasn.blockown.importer.ImporterException;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;

public class MySql
extends Importer {
    public MySql(Database db, File pluginsFolder, Runnable runnable) {
        super(db, pluginsFolder, runnable);
    }

    @Override
    public void run() {
        String worldName;
        ResultSet rs;
        Statement stmnt;
        Connection con;
        if (this.db instanceof MySqlDatabase) {
            return;
        }
        try {
            Class.forName("com.mysql.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new ImporterException("No mysql driver found");
        }
        String host = Setting.DATABASE_MYSQL_HOST.get().toString();
        int port = Setting.DATABASE_MYSQL_PORT.get();
        String databaseName = Setting.DATABASE_MYSQL_DATABASE.get().toString();
        String username = Setting.DATABASE_MYSQL_USER.get().toString();
        String password = Setting.DATABASE_MYSQL_PASSWORD.get().toString();
        String url = password.equals("") ? "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?user=" + username + "&autoReconnect=true" : "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?user=" + username + "&password=" + password + "&autoReconnect=true";
        try {
            con = DriverManager.getConnection(url);
        }
        catch (SQLException e) {
            throw new ImporterException(e.getMessage());
        }
        try {
            stmnt = con.createStatement();
            rs = stmnt.executeQuery("SELECT * FROM block_table;");
            while (rs.next()) {
                int z;
                int y;
                int x;
                worldName = rs.getString("world");
                OwnedBlock block = OwnedBlock.newInstance(worldName, x = rs.getInt("x"), y = rs.getInt("y"), z = rs.getInt("z"));
                if (!this.db.getOwner(block).isNobody()) continue;
                User owner = User.getInstance(UUID.fromString(rs.getString("player_id")));
                DatabaseAction databaseAction = DatabaseAction.newOwnInstance(block, owner);
                this.db.enqueue(databaseAction);
            }
            stmnt.close();
        }
        catch (SQLException e) {
            throw new ImporterException(e.getMessage());
        }
        try {
            stmnt = con.createStatement();
            rs = stmnt.executeQuery("SELECT * FROM entity_table;");
            while (rs.next()) {
                worldName = rs.getString("world");
                OwnedEntity entity = OwnedEntity.newInstance(UUID.fromString(rs.getString("entity_id")), worldName);
                if (!this.db.getOwner(entity).isNobody()) continue;
                User owner = User.getInstance(UUID.fromString(rs.getString("player_id")));
                DatabaseAction databaseAction = DatabaseAction.newOwnInstance(entity, owner);
                this.db.enqueue(databaseAction);
            }
            stmnt.close();
            con.close();
            this.finished();
        }
        catch (SQLException e) {
            throw new ImporterException(e.getMessage());
        }
    }
}

