/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.Output;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseOperation;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class Database
implements Runnable {
    static final String PLAYER_ID_COLUMN = "player_id";
    static final String WORLD_COLUMN = "world";
    static final String ENTITY_ID_COLUMN = "entity_id";
    static final String X_COLUMN = "x";
    static final String Y_COLUMN = "y";
    static final String Z_COLUMN = "z";
    static final String BLOCK_TABLE = "block_table";
    static final String ENTITY_TABLE = "entity_table";
    final ExecutorService threadPool;
    volatile boolean disable = false;
    final Output output;
    Connection connection;

    Database(Output output) {
        this.output = output;
        this.threadPool = Executors.newCachedThreadPool();
    }

    Output getOutput() {
        return this.output;
    }

    public void enqueue(DatabaseAction databaseAction) {
        try {
            this.threadPool.execute(new DatabaseOperation(this, databaseAction));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public User getOwner(Ownable ownable) {
        return this.getDatabaseOwner(ownable);
    }

    public final void disable() {
        this.disable = true;
    }

    @Override
    public void run() {
        while (!this.disable) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ignored) {}
        }
        this.threadPool.shutdown();
        this.getOutput().debugMessage("Waiting for database actions termination");
        try {
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.close();
    }

    void createTables() throws SQLException {
        Statement stmnt = this.connection.createStatement();
        for (String query : this.generateCreateTableQueries()) {
            stmnt.executeUpdate(query);
        }
        stmnt.close();
    }

    User getDatabaseOwner(Ownable ownable) {
        try {
            Statement stmnt = this.connection.createStatement();
            String query = this.generateGetOwnerQuery(ownable);
            ResultSet rs = stmnt.executeQuery(query);
            if (rs.next()) {
                User owner = User.getInstance(UUID.fromString(rs.getString(PLAYER_ID_COLUMN)));
                stmnt.close();
                return owner;
            }
            stmnt.close();
            return User.nobody;
        }
        catch (SQLException e) {
            this.getOutput().printException("Couldn't retrieve owner of ownable " + ownable, e);
            return null;
        }
        catch (IllegalArgumentException e) {
            this.getOutput().printException("Couldn't retrieve owner of ownable " + ownable, e);
            return null;
        }
    }

    boolean setDatabaseOwner(DatabaseAction databaseAction) {
        try {
            Statement stmnt = this.connection.createStatement();
            if (databaseAction.getActionType() == DatabaseAction.Type.UNOWN) {
                String query;
                try {
                    query = this.generateDeleteOwnerQuery(databaseAction.getOwnable());
                }
                catch (IllegalArgumentException e) {
                    this.getOutput().printException(e);
                    stmnt.close();
                    return false;
                }
                stmnt.executeUpdate(query);
                stmnt.close();
                return true;
            }
            if (databaseAction.getActionType() == DatabaseAction.Type.OWN) {
                String query;
                try {
                    query = this.generateSetOwnerQuery(databaseAction);
                }
                catch (IllegalArgumentException e) {
                    this.getOutput().printException(e);
                    stmnt.close();
                    return false;
                }
                stmnt.executeUpdate(query);
                stmnt.close();
                return true;
            }
            this.getOutput().printException(new IllegalArgumentException("Invalid DatabaseActionType"));
            stmnt.close();
            return false;
        }
        catch (SQLException e) {
            this.getOutput().printException(e);
            return false;
        }
    }

    void dropDatabaseUserData(User user) {
        if (user.isNobody()) {
            return;
        }
        try {
            Statement stmnt = this.connection.createStatement();
            for (String query : this.generateDropUserQueries(user)) {
                stmnt.executeUpdate(query);
            }
            stmnt.close();
        }
        catch (SQLException e) {
            this.getOutput().printException("Exception while dropping the owning data for " + user.getName(), e);
        }
    }

    boolean flushDatabase(Map<Ownable, User> cacheData) {
        Iterator<Map.Entry<Ownable, User>> iterator = cacheData.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Ownable, User> owning = iterator.next();
            DatabaseAction action = owning.getValue().isNobody() ? DatabaseAction.newUnownInstance(owning.getKey()) : DatabaseAction.newOwnInstance(owning.getKey(), owning.getValue());
            if (!this.setDatabaseOwner(action)) {
                return false;
            }
            iterator.remove();
        }
        return true;
    }

    void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            this.getOutput().printError("Couldn't close database connection", e);
        }
    }

    abstract String[] generateCreateTableQueries();

    abstract String generateGetOwnerQuery(Ownable var1);

    abstract String generateSetOwnerQuery(DatabaseAction var1);

    abstract String generateDeleteOwnerQuery(Ownable var1);

    abstract String[] generateDropUserQueries(User var1);
}

