/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.CachedDatabase;
import de.pheasn.blockown.database.DatabaseAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;

class CacheAccessor {
    private static final int BLOCKS_PER_PLAYER = 1024;
    private static final int DEFAULT_START_CAPACITY = 65536;
    private static final int CACHE_TIME = 15;
    private final File dumpFile;
    private final CachedDatabase db;
    private final LoadingCache<Ownable, User> cache;
    private Map<Ownable, User> unsubmitted;

    CacheAccessor(CachedDatabase database, File pluginFolder) {
        this.db = database;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)this.calculateCacheCapacity()).expireAfterAccess(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<Ownable, User>(){

            public User load(Ownable ownable) throws Exception {
                return CacheAccessor.this.db.getDatabaseOwner(ownable);
            }
        });
        this.dumpFile = new File(pluginFolder.getAbsoluteFile(), "dumpFile.dat");
        if (this.dumpFile.exists()) {
            this.unsubmitted = this.restoreDumpedCache();
            this.cache.putAll(this.unsubmitted);
        } else {
            this.unsubmitted = this.initializeCache();
        }
    }

    private Map<Ownable, User> initializeCache() {
        return new ConcurrentHashMap<Ownable, User>(this.calculateCacheCapacity());
    }

    private int calculateCacheCapacity() {
        int initialCapacity;
        try {
            initialCapacity = Bukkit.getOfflinePlayers().length * 1024;
        }
        catch (NullPointerException e) {
            initialCapacity = 0;
        }
        if (initialCapacity == 0) {
            initialCapacity = 65536;
        }
        return initialCapacity;
    }

    private Map<Ownable, User> restoreDumpedCache() {
        Map result;
        block5: {
            result = null;
            try {
                ObjectInputStream ois = new ObjectInputStream(new FileInputStream(this.dumpFile));
                Object o = ois.readObject();
                ois.close();
                if (o instanceof Map) {
                    assert (((Map)o).keySet().iterator().next() instanceof Ownable);
                    assert (((Map)o).values().iterator().next() instanceof User);
                    result = (Map)o;
                }
                this.dumpFile.delete();
            }
            catch (IOException | ClassNotFoundException e) {
                this.db.getOutput().printException("Error restoring dumped cacheAccessor.", e);
                if (this.dumpFile.delete()) break block5;
                this.db.getOutput().printError("Couldn't delete corrupted cache dump, please delete " + this.dumpFile.getAbsolutePath() + " manually", e);
            }
        }
        return result == null ? this.initializeCache() : result;
    }

    User getOwner(Ownable ownable) {
        try {
            return (User)this.cache.get((Object)ownable);
        }
        catch (ExecutionException e) {
            this.db.getOutput().printException("ExecutionException in CacheAccessor", e);
            return User.nobody;
        }
    }

    boolean doAction(DatabaseAction databaseAction) {
        switch (databaseAction.getActionType()) {
            case UNOWN: {
                this.cache.put((Object)databaseAction.getOwnable(), (Object)User.nobody);
                this.unsubmitted.put(databaseAction.getOwnable(), User.nobody);
                return true;
            }
            case OWN: {
                this.cache.put((Object)databaseAction.getOwnable(), (Object)databaseAction.getUser());
                this.unsubmitted.put(databaseAction.getOwnable(), databaseAction.getUser());
                return true;
            }
            case DROP: {
                this.dropUserData(databaseAction.getUser());
                return true;
            }
        }
        this.db.getOutput().printException(new IllegalArgumentException("Invalid DatabaseActionType"));
        return false;
    }

    synchronized void flush() {
        if (!this.db.flushDatabase(this.unsubmitted)) {
            try {
                this.dumpFile.createNewFile();
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(this.dumpFile, false));
                oos.writeObject(this.unsubmitted);
                oos.close();
            }
            catch (IOException e) {
                this.db.getOutput().printException("Exception while flushing cache", e);
            }
            this.db.getOutput().printConsole("The cache has been dumped to the hard drive");
        }
    }

    private void dropUserData(User user) {
        if (user == null) {
            return;
        }
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            if (!user.equals(entry.getValue())) continue;
            this.cache.put(entry.getKey(), (Object)User.nobody);
        }
        for (Map.Entry<Object, Object> entry : this.unsubmitted.entrySet()) {
            if (!user.equals(entry.getValue())) continue;
            entry.setValue(User.nobody);
        }
        this.db.dropDatabaseUserData(user);
    }
}

