/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.Selection;
import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.InvalidWorldException;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.Setting;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.command.CommandExecutor;
import de.pheasn.blockown.command.RegionIterator;
import de.pheasn.blockown.command.UnownRunner;
import de.pheasn.blockown.database.DatabaseAction;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CE_Unown
extends CommandExecutor {
    private static final String PARAM_SELECTION = "selection";
    private static final String PARAM_ENTITY = "e";
    private static final String PARAM_BLOCK = "b";
    private final WorldEditPlugin worldEdit;

    public CE_Unown(BlockOwn plugin) {
        super(plugin);
        this.worldEdit = (WorldEditPlugin)plugin.getServer().getPluginManager().getPlugin("WorldEdit");
    }

    @Override
    protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
        if (!player.hasPermission(Permission.OWN_UNOWN.toString())) {
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_PERMISSION);
            return true;
        }
        if (!this.plugin.isEnabledInWorld(player.getWorld())) {
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_DISABLED_IN_WORLD);
            return true;
        }
        User user = User.getInstance(player.getUniqueId());
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase(PARAM_SELECTION)) {
                if (!player.hasPermission(Permission.OWN_OWNSELECTION.toString())) {
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_PERMISSION);
                    return true;
                }
            } else {
                if (args[0].equalsIgnoreCase(PARAM_ENTITY)) {
                    if (this.plugin.isWaiting(user, WaitType.UNOWN_ENTITY)) {
                        this.plugin.removeWaiting(user);
                        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    } else {
                        this.plugin.addWaiting(user, WaitType.UNOWN_ENTITY);
                        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNOWN_CLICK_ENTITY);
                    }
                    return true;
                }
                if (args[0].equalsIgnoreCase(PARAM_BLOCK)) {
                    if (this.plugin.isWaiting(user, WaitType.UNOWN_BLOCK)) {
                        this.plugin.removeWaiting(user);
                        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    } else {
                        this.plugin.addWaiting(user, WaitType.UNOWN_BLOCK);
                        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNOWN_CLICK_BLOCK);
                    }
                    return true;
                }
                return false;
            }
            if (this.worldEdit != null) {
                int areaSize;
                Selection selection = this.worldEdit.getSelection(player);
                if (selection == null) {
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNOWN_SELECTION_NOSELECTION);
                    return true;
                }
                int maxSelection = Setting.DATABASE_MAX_SELECTION.get();
                if (maxSelection > 0 && (areaSize = selection.getArea()) > maxSelection) {
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNOWN_SELECTION_TOO_BIG, maxSelection);
                    return true;
                }
                Location min = selection.getMinimumPoint();
                Location max = selection.getMaximumPoint();
                RegionIterator region = new RegionIterator(min, max);
                Thread t = new Thread((Runnable)new UnownRunner(this.plugin, region, user, player), "UnownselectionThread");
                t.start();
                return true;
            }
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNOWN_SELECTION_NOWORLDEDIT);
            return true;
        }
        if (args.length == 0) {
            Block targetBlock = player.getTargetBlock((Set)null, 20);
            if (targetBlock != null) {
                OwnedBlock block = OwnedBlock.newInstance(targetBlock);
                if (this.plugin.getOwningDatabase().getOwner(block).equals(user) || player.hasPermission(Permission.ADMIN_UNOWN.toString())) {
                    try {
                        DatabaseAction databaseAction = DatabaseAction.newUnownInstance(block);
                        this.plugin.getOwningDatabase().enqueue(databaseAction);
                        this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNOWN_BLOCKSUCCESS, block.getMaterial().getName());
                        return true;
                    }
                    catch (InvalidWorldException e) {
                        this.plugin.getOutput().printError("This should never happen! CE_UNOWN", e);
                        return false;
                    }
                }
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNOWN_FOROTHERS_NOTALLOWED);
                return false;
            }
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NOTARGET);
            return false;
        }
        return false;
    }
}

