/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.command.CommandExecutor;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.importer.Importer;
import de.pheasn.blockown.importer.ImporterException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CE_Import
extends CommandExecutor {
    private final ClassLoader externalImportClassLoader;
    private final boolean folderAccess;

    public CE_Import(BlockOwn plugin) {
        super(plugin);
        URL url = null;
        try {
            url = plugin.getImporterFolder().toURI().toURL();
        }
        catch (MalformedURLException e) {
            plugin.getOutput().printException("Error accessing Importer folder, import command unavailable", e);
            this.folderAccess = false;
            this.externalImportClassLoader = null;
            return;
        }
        this.externalImportClassLoader = url != null ? URLClassLoader.newInstance(new URL[]{url}, plugin.getClass().getClassLoader()) : null;
        this.folderAccess = true;
    }

    @Override
    public boolean onCommand(final CommandSender sender, Command cmd, String cmdName, String[] args) {
        Class<? extends Importer> importerClass;
        if (!this.folderAccess) {
            this.plugin.getOutput().sendMessage(sender, Message.COMMAND_IMPORT_UNAVAILABLE);
            return false;
        }
        if (sender instanceof Player) {
            this.plugin.getOutput().sendMessage(sender, Message.COMMAND_CONSOLE_ONLY);
            return false;
        }
        if (args.length != 1) {
            return false;
        }
        try {
            importerClass = this.findClass(args[0]);
        }
        catch (ClassNotFoundException e) {
            this.plugin.getOutput().printException("No matching importer found", e);
            return false;
        }
        try {
            Importer importer = importerClass.getConstructor(Database.class, File.class, Runnable.class).newInstance(this.plugin.getOwningDatabase(), new File("plugins"), new Runnable(){

                @Override
                public void run() {
                    CE_Import.this.plugin.getOutput().sendMessage(sender, Message.COMMAND_IMPORT_SUCCESS);
                }
            });
            Thread importThread = new Thread((Runnable)importer, "Import Thread");
            this.plugin.getOutput().sendMessage(sender, Message.COMMAND_IMPORT_START);
            importThread.start();
            return true;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.plugin.getOutput().printException("There probably was an error in the requested importer class", e);
            return false;
        }
        catch (ImporterException e) {
            this.plugin.getOutput().printException(e.getMessage(), e);
            return false;
        }
    }

    @Override
    protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
        return false;
    }

    private Class<? extends Importer> findClass(String name) throws ClassNotFoundException {
        Class<?> result;
        block4: {
            result = null;
            try {
                Class<?> found = Class.forName("de.pheasn.blockown.importer." + name);
                if (Importer.class.isAssignableFrom(found) && !found.isInterface()) {
                    result = found;
                }
            }
            catch (ClassNotFoundException e) {
                Class<?> found;
                if (this.externalImportClassLoader == null || !Importer.class.isAssignableFrom(found = this.externalImportClassLoader.loadClass(name)) || found.isInterface()) break block4;
                result = found;
            }
        }
        if (result == null) {
            throw new ClassNotFoundException();
        }
        return result;
    }
}

