package de.pheasn.blockown.importer;

import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ItemFrame;

import java.io.*;
import java.sql.*;
import java.util.UUID;

public class BlockOwn2 extends Importer {

	public BlockOwn2(Database db, File pluginsFolder, Runnable runnable) {
		super(db, pluginsFolder, runnable);
	}

	@Override
	public void run() {
		File configFile = new File(pluginsFolder, "BlockOwn2/config.yml");
		if (!configFile.exists()) {
			throw new ImporterException("Old config.yml not found!");
		}
		FileConfiguration config = YamlConfiguration.loadConfiguration(configFile);

		if (!config.getString("Settings-Version").equalsIgnoreCase("2.0.2")) {
			throw new ImporterException("Old config must have version 2.0.2");
		}

		String url;
		try {
			if (config.getBoolean("ServerSettings.MySQL.enable")) {
				String type = config.getString("ServerSettings.MySQL.type");
				if (type.equalsIgnoreCase("network")) {
					Class.forName("com.mysql.jdbc.Driver");
					String host = config.getString("ServerSettings.MySQL.host");
					int port = config.getInt("ServerSettings.MySQL.port");
					String databaseName = config.getString("ServerSettings.MySQL.database");
					String username = config.getString("ServerSettings.MySQL.user");
					String password = config.getString("ServerSettings.MySQL.password");
					url = "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?user="
							+ username + "&password=" + password + "&autoReconnect=true";
				} else {
					Class.forName("org.sqlite.JDBC");
					url = "jdbc:sqlite:" + pluginsFolder.getPath() + "/BlockOwn2/data.db";
				}
			} else {
				importClassic();
				return;
			}
		} catch (ClassNotFoundException e) {
			throw new ImporterException("driver class not found");
		}

		try {
			Connection con = DriverManager.getConnection(url);
			Statement stmnt = con.createStatement();
			ResultSet rs = stmnt.executeQuery("SELECT * FROM block INNER JOIN player ON block.ownerid=player.playerid;");

			Ownable ownable;
			int count = 0;
			int skipped = 0;
			while (rs.next()) {
				count++;
				boolean isBlock = rs.getBoolean("isblock");
				String worldName = rs.getString("world");
				int x = rs.getInt("x");
				int y = rs.getInt("y");
				int z = rs.getInt("z");
				User owner = User.getInstance(UUID.fromString(rs.getString("uuid")));
				if (!isBlock) {
					ItemFrame iF = getItemFrame(worldName, x, y, z);
					if (iF == null) {
						skipped++;
						continue;
					}
					ownable = OwnedEntity.newInstance(iF);
				} else {
					ownable = OwnedBlock.newInstance(worldName, x, y, z);
				}
				own(ownable, owner);
			}
			System.out.println("Import skipped " + skipped + " of " + count + " entries.");
			stmnt.close();
			con.close();
			finished();
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}
	}

	private void own(Ownable ownable, User owner) {
		if (db.getOwner(ownable).isNobody()) {
			DatabaseAction databaseAction = DatabaseAction.newOwnInstance(ownable, owner);
			db.enqueue(databaseAction);
		}
	}

	private void importClassic() throws ImporterException {
		File file = new File(pluginsFolder, "BlockOwn2/blocks.dat");
		if (!file.exists()) throw new ImporterException("Flat file database doesn't exist");
		try {
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
			String line;
			Ownable ownable;
			int count = 0;
			int skipped = 0;
			while ((line = br.readLine()) != null) {
				count++;
				String[] owningDiv = line.split(":");
				String worldName = owningDiv[0];
				String[] blockCoordinates = owningDiv[1].split("#");
				String playerId = owningDiv[2];
				boolean isBlock = (owningDiv[3].equalsIgnoreCase("1"));
				User owner = User.getInstance(UUID.fromString(playerId));
				int x = Integer.parseInt(blockCoordinates[0]);
				int y = Integer.parseInt(blockCoordinates[1]);
				int z = Integer.parseInt(blockCoordinates[2]);
				if (isBlock) {
					ownable = OwnedBlock.newInstance(worldName, x, y, z);
				} else {
					ItemFrame iF = getItemFrame(worldName, x, y, z);
					if (iF == null) {
						skipped++;
						continue;
					} else {
						ownable = OwnedEntity.newInstance(iF);
					}
				}
				own(ownable, owner);
				count++;
			}
			System.out.println("Import skipped " + skipped + " of " + count + " entries.");
			br.close();
			finished();
		} catch (IOException e) {
			throw new ImporterException(e.getMessage());
		}
	}
}
