package de.pheasn.blockown.importer;

import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.ItemFrame;

import java.io.*;
import java.sql.*;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BlockOwn1 extends Importer {

	public BlockOwn1(Database db, File pluginsFolder, Runnable runnable) {
		super(db, pluginsFolder, runnable);
	}

	@Override
	public void run() {
		File configFile = new File(pluginsFolder, "BlockOwn1/config.yml");
		if (!configFile.exists()) {
			throw new ImporterException("Old config.yml not found!");
		}
		FileConfiguration config = YamlConfiguration.loadConfiguration(configFile);

		if (!config.getString("Settings-Version").equalsIgnoreCase("1.3.7")) {
			throw new ImporterException("Old config must have version 1.3.7");
		}

		String url;
		try {
			if (config.getBoolean("ServerSettings.MySQL.enable")) {
				String type = config.getString("ServerSettings.MySQL.type");
				if (type.equalsIgnoreCase("network")) {
					Class.forName("com.mysql.jdbc.Driver");
					String host = config.getString("ServerSettings.MySQL.host");
					int port = config.getInt("ServerSettings.MySQL.port");
					String databaseName = config.getString("ServerSettings.MySQL.database");
					String username = config.getString("ServerSettings.MySQL.user");
					String password = config.getString("ServerSettings.MySQL.password");
					url = "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?user="
							+ username + "&password=" + password + "&autoReconnect=true";
				} else {
					Class.forName("org.sqlite.JDBC");
					url = "jdbc:sqlite:" + pluginsFolder.getPath() + "/BlockOwn1/data.db";
				}
			} else {
				importClassic(db);
				return;
			}
		} catch (ClassNotFoundException e) {
			throw new ImporterException("driver class not found");
		}

		try {
			Connection con = DriverManager.getConnection(url);
			Statement stmnt = con.createStatement();

			ResultSet nameSet = stmnt.executeQuery("SELECT playername FROM player;");
			List<String> names = new LinkedList<>();
			while (nameSet.next()) {
				names.add(nameSet.getString("playername"));
			}
			stmnt.close();
			Map<String, UUID> users;
			try {
				users = getUsers(names);
			} catch (Exception e) {
				System.out.println("Error while fetching UUIDs");
				return;
			}

			stmnt = con.createStatement();
			ResultSet blockSet = stmnt.executeQuery("SELECT * FROM block INNER JOIN player ON block.ownerid=player.playerid;");

			Ownable ownable;
			DatabaseAction databaseAction;
			int count = 0;
			int skipped = 0;
			while (blockSet.next()) {
				count++;
				boolean isBlock = blockSet.getBoolean("isblock");
				String worldName = blockSet.getString("world");
				int x = blockSet.getInt("x");
				int y = blockSet.getInt("y");
				int z = blockSet.getInt("z");

				User owner;
				UUID id = users.get(blockSet.getString("playername"));
				if (id == null) {
					skipped++;
					continue;
				}
				owner = User.getInstance(id);

				if (!isBlock) {
					ItemFrame iF = getItemFrame(worldName, x, y, z);
					if (iF == null) {
						skipped++;
						continue;
					}
					ownable = OwnedEntity.newInstance(iF);
				} else {
					ownable = OwnedBlock.newInstance(worldName, x, y, z);
				}
				if (db.getOwner(ownable).isNobody()) {
					databaseAction = DatabaseAction.newOwnInstance(ownable, owner);
					db.enqueue(databaseAction);
				}
			}
			System.out.println("Import skipped " + skipped + " of " + count + " entries.");
			stmnt.close();
			con.close();
			finished();
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}
	}

	private void importClassic(Database db) throws ImporterException {
		File file = new File(pluginsFolder, "BlockOwn1/blocks.dat");
		if (!file.exists())
			throw new ImporterException("Flat file database doesn't exist");
		try {
			BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
			String line;
			Ownable ownable;
			int count = 0;
			int skipped = 0;
			DatabaseAction databaseAction;
			while ((line = br.readLine()) != null) {
				count++;
				String[] owningDiv = line.split(":"); //$NON-NLS-1$
				String worldName = owningDiv[0];
				String[] blockCoordinates = owningDiv[1].split("#"); //$NON-NLS-1$
				String playerName = owningDiv[2];
				boolean isBlock = (owningDiv[3].equalsIgnoreCase("1")); //$NON-NLS-1$
				User owner = getUser(playerName);
				if (owner == null) {
					skipped++;
					continue;
				}
				int x = Integer.parseInt(blockCoordinates[0]);
				int y = Integer.parseInt(blockCoordinates[1]);
				int z = Integer.parseInt(blockCoordinates[2]);

				if (isBlock) {
					ownable = OwnedBlock.newInstance(worldName, x, y, z);
				} else {
					ItemFrame iF = getItemFrame(worldName, x, y, z);
					if (iF == null) {
						skipped++;
						continue;
					}
					ownable = OwnedEntity.newInstance(iF);
				}
				if (db.getOwner(ownable).isNobody()) {
					databaseAction = DatabaseAction.newOwnInstance(ownable, owner);
					db.enqueue(databaseAction);
				}
			}
			System.out.println("Import skipped " + skipped + " of " + count + " entries.");
			br.close();
			finished();
		} catch (IOException e) {
			throw new ImporterException(e.getMessage());
		}
	}
}
