package de.pheasn.blockown.event;

import de.pheasn.blockown.*;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.protection.ProtectAction;

import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class L_PlayerInteract extends Listener {

    public L_PlayerInteract(BlockOwn plugin) {
        super(plugin);
    }

    @EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
    public void onPlayerBlockInteract(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) return;

        if (block.getType() == org.bukkit.Material.AIR) {
            return;
        }

        if (Setting.PROTECTION_ALLOW_RIGHT_CLICKS.get() && event.getAction().equals(Action.RIGHT_CLICK_BLOCK)) {
            return;
        }

        if (!plugin.isEnabledInWorld(event.getClickedBlock().getWorld())) return;

        User user = User.getInstance(event.getPlayer().getUniqueId());
        if (plugin.isIgnoring(user)) return;
        OwnedBlock ownedBlock = OwnedBlock.newInstance(block);
        try {
            if (invalid(ownedBlock, user)) {
                event.setCancelled(true);
            }
        } catch (InvalidWorldException e) {
            // can't happen, since the OwnedBlock is backed by a bukkit Block
            plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
        }
    }

    @EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
    public void onPlayerEntityInteract(PlayerInteractEntityEvent event) {
        if (Setting.PROTECTION_ALLOW_RIGHT_CLICKS.get()) {
            return;
        }

        if (!plugin.isEnabledInWorld(event.getRightClicked().getWorld())) return;

        User user = User.getInstance(event.getPlayer().getUniqueId());
        if (plugin.isIgnoring(user)) return;
        OwnedEntity entity = OwnedEntity.newInstance(event.getRightClicked());
        try {
            if (invalid(entity, user)) {
                event.setCancelled(true);
            }
        } catch (InvalidWorldException e) {
            // can't happen, since the OwnedEntity is backed by a bukkit Entity
            plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
        }
    }

    @EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
    public void onPlayerDamageEntity(EntityDamageByEntityEvent event) {
        if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
        if (event.getDamager() instanceof Player) {
            Player player = (Player) event.getDamager();
            User user = User.getInstance(player.getUniqueId());
            if (plugin.isIgnoring(user)) return;
            OwnedEntity entity = OwnedEntity.newInstance(event.getEntity());
            try {
                if (invalid(entity, user)) {
                    event.setCancelled(true);
                }
            } catch (InvalidWorldException e) {
                // can't happen, since the OwnedEntity is backed by a bukkit Entity
                plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
            }
        }
    }

    @EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
    public void onPlayerBreakHanging(HangingBreakByEntityEvent event) {
        if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
        if (event.getRemover() instanceof Player) {
            Player player = (Player) event.getRemover();
            User user = User.getInstance(player.getUniqueId());
            if (plugin.isIgnoring(user)) return;
            OwnedEntity entity = OwnedEntity.newInstance(event.getEntity());
            try {
                if (invalid(entity, user)) {
                    event.setCancelled(true);
                }
            } catch (InvalidWorldException e) {
                // can't happen, since the OwnedEntity is backed by a bukkit Entity
                plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
            }
        }
    }

    private boolean invalid(Ownable ownable, User user) throws InvalidWorldException {
        User owner = plugin.getOwningDatabase().getOwner(ownable);
        if (owner.isNobody()) return false;
        return !owner.equals(user) && !user.hasAccess(ownable);
    }

    /*
    * Handle entity choosing
    */
    @EventHandler(priority = EventPriority.LOWEST)
    public void onPlayerChooseEntity(PlayerInteractEntityEvent event) {
        if (!plugin.isEnabledInWorld(event.getRightClicked().getWorld())) return;
        User user = User.getInstance(event.getPlayer().getUniqueId());

        WaitType waitType = plugin.getWaiting(user);
        if (waitType == null) return;
        event.setCancelled(true);

        OwnedEntity entity = OwnedEntity.newInstance(event.getRightClicked());
        Material material;
		try {
			material = entity.getMaterial();
		} catch (InvalidWorldException e) {
            // can't happen, since the OwnedEntity is backed by a bukkit Entity
            plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
			return;
		}
		if (!plugin.isOwnEnabled(material)) return;
        User owner = plugin.getOwningDatabase().getOwner(entity);
        Player player = event.getPlayer();

        ProtectAction protectAction;
        DatabaseAction databaseAction;
        switch (waitType) {
            case SHOW_OWNER_ENTITY:
                if (owner.isNobody()) {
                    plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_ENTITY_UNOWNED, material.getName());
                } else {
                    plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_ENTITY_FOUND, owner.getName(), material.getName());
                }
                break;
            case OWN_ENTITY:
                if (owner.isNobody()) {
                    databaseAction = DatabaseAction.newOwnInstance(entity, user);
                    plugin.getOwningDatabase().enqueue(databaseAction);
                    plugin.getOutput().sendMessage(player, Message.COMMAND_OWN_ENTITYSUCCESS, material.getName());
                } else {
                    if(!owner.equals(user))
                        plugin.getOutput().sendMessage(event.getPlayer(), Message.COMMAND_OWN_NOPERMISSIONFOROTHERS);
                }
                break;
            case UNOWN_ENTITY:
                if (owner.equals(user) || player.hasPermission(Permission.ADMIN_UNOWN.toString())) {
                    databaseAction = DatabaseAction.newUnownInstance(entity);
                    plugin.getOwningDatabase().enqueue(databaseAction);
                    plugin.getOutput().sendMessage(event.getPlayer(), Message.COMMAND_UNOWN_ENTITYSUCCESS, material.getName());
                } else {
                    plugin.getOutput().sendMessage(event.getPlayer(), Message.COMMAND_UNOWN_FOROTHERS_NOTALLOWED);
                }
                break;
            case PROTECT_ENTITY:
                protectAction = new ProtectAction.Builder(user).protect(material).build();
                plugin.getProtection().enqueue(protectAction);
                plugin.getOutput().sendMessage(player, Message.COMMAND_PROTECT_SUCCESS, material.getName());
                plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                plugin.removeWaiting(user);
                break;
            case UNPROTECT_ENTITY:
                protectAction = new ProtectAction.Builder(user).unprotect(material).build();
                plugin.getProtection().enqueue(protectAction);
                plugin.getOutput().sendMessage(player, Message.COMMAND_UNPROTECT_SUCCESS, material.getName());
                plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                plugin.removeWaiting(user);
                break;
            case LOCK_ENTITY:
                protectAction = new ProtectAction.Builder(user).lock(material).build();
                plugin.getProtection().enqueue(protectAction);
                plugin.getOutput().sendMessage(player, Message.COMMAND_LOCK_SUCCESS, material.getName());
                plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                plugin.removeWaiting(user);
                break;
            case UNLOCK_ENTITY:
                protectAction = new ProtectAction.Builder(user).unlock(material).build();
                plugin.getProtection().enqueue(protectAction);
                plugin.getOutput().sendMessage(player, Message.COMMAND_UNLOCK_SUCCESS, material.getName());
                plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                plugin.removeWaiting(user);
                break;
            default:
                break;
        }
    }

    /*
    * Handle block choosing
    */
    @EventHandler(priority = EventPriority.LOWEST)
    public void onPlayerChooseBlock(PlayerInteractEvent event) {
        if (event.getAction().equals(Action.RIGHT_CLICK_BLOCK)) {

            Block nativeBlock = event.getClickedBlock();
            if (!plugin.isEnabledInWorld(nativeBlock.getWorld())) return;
            User user = User.getInstance(event.getPlayer().getUniqueId());

            WaitType waitType = plugin.getWaiting(user);
            if (waitType == null) return;
            event.setCancelled(true);

            OwnedBlock block = OwnedBlock.newInstance(nativeBlock);
            Material material;
            try {
                material = block.getMaterial();
            } catch (InvalidWorldException e) {
                // can't happen, since the OwnedBlock is backed by a bukkit Block
                plugin.getOutput().printError("This should never happen! L_PLAYERINTERACT", e);
                return;
            }
            if (!plugin.isOwnEnabled(material)) return;
            User owner = plugin.getOwningDatabase().getOwner(block);
            Player player = event.getPlayer();

            ProtectAction protectAction;
            DatabaseAction databaseAction;

            switch (waitType) {
                case SHOW_OWNER_BLOCK:
                    if (owner.isNobody()) {
                        plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_BLOCK_UNOWNED, material.getName());
                    } else {
                        plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_BLOCK_FOUND, owner.getName(), material.getName());
                    }
                    break;
                case OWN_BLOCK:
                    if (owner.isNobody()) {
                        databaseAction = DatabaseAction.newOwnInstance(block, user);
                        plugin.getOwningDatabase().enqueue(databaseAction);
                        plugin.getOutput().sendMessage(player, Message.COMMAND_OWN_BLOCKSUCCESS, material.getName());
                    } else {
                        if (!owner.equals(user))
                            plugin.getOutput().sendMessage(event.getPlayer(), Message.COMMAND_OWN_NOPERMISSIONFOROTHERS);
                    }
                    break;
                case UNOWN_BLOCK:
                    if (owner.equals(user) || player.hasPermission(Permission.ADMIN_UNOWN.toString())) {
                        databaseAction = DatabaseAction.newUnownInstance(block);
                        plugin.getOwningDatabase().enqueue(databaseAction);
                        plugin.getOutput().sendMessage(event.getPlayer(), Message.COMMAND_UNOWN_BLOCKSUCCESS, material.getName());
                    } else {
                        plugin.getOutput().sendMessage(event.getPlayer(), Message.COMMAND_UNOWN_FOROTHERS_NOTALLOWED);
                    }
                    break;
                case PROTECT_BLOCK:
                    protectAction = new ProtectAction.Builder(user).protect(material).build();
                    plugin.getProtection().enqueue(protectAction);
                    plugin.getOutput().sendMessage(player, Message.COMMAND_PROTECT_SUCCESS, material.getName());
                    plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    plugin.removeWaiting(user);
                    break;
                case UNPROTECT_BLOCK:
                    protectAction = new ProtectAction.Builder(user).unprotect(material).build();
                    plugin.getProtection().enqueue(protectAction);
                    plugin.getOutput().sendMessage(player, Message.COMMAND_UNPROTECT_SUCCESS, material.getName());
                    plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    plugin.removeWaiting(user);
                    break;
                case LOCK_BLOCK:
                    protectAction = new ProtectAction.Builder(user).lock(material).build();
                    plugin.getProtection().enqueue(protectAction);
                    plugin.getOutput().sendMessage(player, Message.COMMAND_LOCK_SUCCESS, material.getName());
                    plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    plugin.removeWaiting(user);
                    break;
                case UNLOCK_BLOCK:
                    protectAction = new ProtectAction.Builder(user).unlock(material).build();
                    plugin.getProtection().enqueue(protectAction);
                    plugin.getOutput().sendMessage(player, Message.COMMAND_UNLOCK_SUCCESS, material.getName());
                    plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
                    plugin.removeWaiting(user);
                    break;
                default:
                    break;
            }
        }
    }
}
