package de.pheasn.blockown.command;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.DatabaseAction;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CE_UnownPlayer extends CommandExecutor {

	public CE_UnownPlayer(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
		if (!sender.hasPermission(Permission.ADMIN_UNOWNPLAYER.toString())) {
			plugin.getOutput().sendMessage(sender, Message.COMMAND_NO_PERMISSION);
			return true;
		}
		if (args.length == 1) {
			@SuppressWarnings("deprecation")
			OfflinePlayer op = plugin.getServer().getOfflinePlayer(args[0]);
			if (op.hasPlayedBefore() || op.isOnline()) {
				User user = User.getInstance(op.getUniqueId());
				DatabaseAction databaseAction = DatabaseAction.newDropInstance(user);
				plugin.getOwningDatabase().enqueue(databaseAction);
				plugin.getOutput().sendMessage(sender, Message.COMMAND_UNOWNPLAYER_SUCCESS, op.getName());
				return true;
			} else {
				plugin.getOutput().sendMessage(sender, Message.COMMAND_INVALID_PLAYER, args[0]);
				return false;
			}
		} else {
			return false;
		}
	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		return false;
	}

}
