package de.pheasn.blockown.command;

import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.bukkit.selections.Selection;

import de.pheasn.blockown.*;
import de.pheasn.blockown.database.DatabaseAction;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import java.util.Iterator;
import java.util.Set;

public class CE_Unown extends CommandExecutor {

	private static final String PARAM_SELECTION = "selection";
	private static final String PARAM_ENTITY = "e";
	private static final String PARAM_BLOCK = "b";

	private final WorldEditPlugin worldEdit;

	public CE_Unown(BlockOwn plugin) {
		super(plugin);
		worldEdit = (WorldEditPlugin) plugin.getServer().getPluginManager().getPlugin("WorldEdit");
	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.OWN_UNOWN.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}

		if (!plugin.isEnabledInWorld(player.getWorld())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_DISABLED_IN_WORLD);
			return true;
		}

		User user = User.getInstance(player.getUniqueId());
		if (args.length == 1) {
			if (args[0].equalsIgnoreCase(PARAM_SELECTION)) {
				if (!player.hasPermission(Permission.OWN_OWNSELECTION.toString())) {
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
					return true;
				}
			} else if (args[0].equalsIgnoreCase(PARAM_ENTITY)) {
				if (plugin.isWaiting(user, WaitType.UNOWN_ENTITY)) {
					plugin.removeWaiting(user);
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
				} else {
					plugin.addWaiting(user, WaitType.UNOWN_ENTITY);
					plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_CLICK_ENTITY);
				}
				return true;
			} else if (args[0].equalsIgnoreCase(PARAM_BLOCK)) {
					if (plugin.isWaiting(user, WaitType.UNOWN_BLOCK)) {
						plugin.removeWaiting(user);
						plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
					} else {
						plugin.addWaiting(user, WaitType.UNOWN_BLOCK);
						plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_CLICK_BLOCK);
					}
					return true;
			} else {
				return false;
			}

			if (worldEdit != null) {
				Selection selection = worldEdit.getSelection(player);

				if (selection == null) {
					plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_SELECTION_NOSELECTION);
					return true;
				}

				int maxSelection = Setting.DATABASE_MAX_SELECTION.get();
				if (maxSelection > 0) {
					int areaSize = selection.getArea();
					if (areaSize > maxSelection) {
						plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_SELECTION_TOO_BIG, maxSelection);
						return true;
					}
				}

				Location min = selection.getMinimumPoint();
				Location max = selection.getMaximumPoint();
				Iterator<Block> region = new RegionIterator(min, max);

				Thread t = new Thread(new UnownRunner(plugin, region, user, player), "UnownselectionThread");
				t.start();

				return true;
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_SELECTION_NOWORLDEDIT);
				return true;
			}

		} else if (args.length == 0) {
			Block targetBlock = player.getTargetBlock((Set<org.bukkit.Material>) null, 20);
			if (targetBlock != null) {
				OwnedBlock block = OwnedBlock.newInstance(targetBlock);
				if (plugin.getOwningDatabase().getOwner(block).equals(user) || player.hasPermission(Permission.ADMIN_UNOWN.toString())) {
					try {
						DatabaseAction databaseAction = DatabaseAction.newUnownInstance(block);
						plugin.getOwningDatabase().enqueue(databaseAction);
						plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_BLOCKSUCCESS, block.getMaterial().getName());
						return true;
					} catch (InvalidWorldException e) {
						// can't happen, since targetBlock is not null and it's world is used
						plugin.getOutput().printError("This should never happen! CE_UNOWN", e);
						return false;
					}
				} else {
					plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_FOROTHERS_NOTALLOWED);
					return false;
				}
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_NOTARGET);
				return false;
			}
		} else {
			return false;
		}
	}
}
