package de.pheasn.blockown.command;

import de.pheasn.blockown.*;
import de.pheasn.blockown.protection.ProtectAction;

import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import java.util.Set;

public class CE_Protect extends CommandExecutor {

	private static final String PARAM_ENTITY = "e";
	private static final String PARAM_BLOCK = "b";

	public CE_Protect(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.PROTECTION_PROTECT.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}

		if (args.length == 1) {
			User user = User.getInstance(player.getUniqueId());
			if (args[0].equalsIgnoreCase(PARAM_ENTITY)) {
				if (plugin.isWaiting(user, WaitType.PROTECT_ENTITY)) {
					plugin.removeWaiting(user);
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
				} else {
					plugin.addWaiting(user, WaitType.PROTECT_ENTITY);
					plugin.getOutput().sendMessage(player, Message.COMMAND_PROTECT_CLICK_ENTITY);
				}
				return true;
			}
			if (args[0].equalsIgnoreCase(PARAM_BLOCK)) {
				if (plugin.isWaiting(user, WaitType.PROTECT_BLOCK)) {
					plugin.removeWaiting(user);
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
				} else {
					plugin.addWaiting(user, WaitType.PROTECT_BLOCK);
					plugin.getOutput().sendMessage(player, Message.COMMAND_PROTECT_CLICK_BLOCK);
				}
				return true;
			}
			try {
				Material material = Material.parseMaterial(args[0]);
				ProtectAction protectAction = new ProtectAction.Builder(user).protect(material).build();
				plugin.getProtection().enqueue(protectAction);
				plugin.getOutput().sendMessage(player, Message.COMMAND_PROTECT_SUCCESS, material.getName());
				return true;
			} catch (IllegalArgumentException e) {
				plugin.getOutput().sendMessage(player, Message.COMMAND_INVALID_MATERIAL, args[0]);
				return false;
			}
		} else if (args.length == 0) {
			Block targetBlock = player.getTargetBlock((Set<org.bukkit.Material>) null, 20);
			if (targetBlock != null) {
				Material material;
				try {
					material = (OwnedBlock.newInstance(targetBlock)).getMaterial();
					User user = User.getInstance(player.getUniqueId());
					ProtectAction protectAction = new ProtectAction.Builder(user).protect(material).build();
					plugin.getProtection().enqueue(protectAction);
					plugin.getOutput().sendMessage(player, Message.COMMAND_PROTECT_SUCCESS, material.getName());
					return true;
				} catch (InvalidWorldException e) {
					// can't happen, since targetBlock is not null and it's world is used
					plugin.getOutput().printError("This should never happen! CE_PROTECT", e);
					return false;
				}
			} else {
				plugin.getOutput().sendMessage(player, Message.COMMAND_NOTARGET);
				return false;
			}
		} else {
			return false;
		}
	}

}
