package de.pheasn.blockown.command;

import de.pheasn.blockown.*;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class CE_List extends CommandExecutor {

	private static final String PARAM_PROTECTED = "protected";
	private static final String PARAM_FRIENDS = "friends";
	private static final String PARAM_LOCKED = "locked";

	public CE_List(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.PROTECTION_LIST.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}

		if (args.length == 1) {
			User user = User.getInstance(player.getUniqueId());
			Set<?> list;
			Message messageHead;
			if (args[0].equalsIgnoreCase(PARAM_FRIENDS)) {
				list = plugin.getProtection().getFriends(user);
				messageHead = Message.COMMAND_LIST_FRIENDS;
			} else if (args[0].equalsIgnoreCase(PARAM_LOCKED)) {
				list = plugin.getProtection().getLocks(user);
				messageHead = Message.COMMAND_LIST_LOCKED;
			} else if (args[0].equalsIgnoreCase(PARAM_PROTECTED)) {
				list = plugin.getProtection().getProtections(user);
				messageHead = Message.COMMAND_LIST_PROTECTED;
			} else {
				return false;
			}
			printList(user, player, messageHead, list);
			return true;
		} else {
			return false;
		}
	}

	private void printList(User user, Player player, Message messageHead, Collection<?> collection) {
		Iterator<?> iterator = collection.iterator();
		StringBuilder message = new StringBuilder(100);
		if (iterator.hasNext()) {
			message.append(messageHead).append(System.lineSeparator()).append(ChatColor.AQUA);
		} else {
			plugin.getOutput().sendMessage(player, Message.COMMAND_LIST_EMPTY);
			return;
		}
		Object o;
		if (collection.contains(Material.ANY)) {
			message.append(Material.ANY.toString()).append(System.lineSeparator());
		} else {
			while (iterator.hasNext()) {
				o = iterator.next();
				message.append(o.toString()).append(System.lineSeparator());
			}
		}
		player.sendMessage(message.toString());
	}

}
