package de.pheasn.blockown;

import org.bukkit.World;

import java.io.Serializable;

public interface Ownable extends Serializable {

	/**
	 * Returns the World the Ownable is in. Never null.
	 *
	 * @return the World
	 * @throws InvalidWorldException if the world referenced by the world name doesn't exist
	 */
	World getWorld() throws InvalidWorldException;

	/**
	 * Returns the name of the world the Ownable is in. Never null.
	 * @return the world name
	 */
	String getWorldName();

	/**
	 * Returns the Material of the Ownable. Never null.
	 *
	 * @return the Material
	 * @throws InvalidWorldException if the world referenced by the world name doesn't exist
	 */
	Material getMaterial() throws InvalidWorldException;
}
