package de.pheasn.blockown;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;

public class Message {

	public static final String COLOR_ERROR = "error";
	public static final String COLOR_WARNING = "warning";
	public static final String COLOR_INFO = "info";
	public static final String COLOR_SUCCESS = "success";

	public static final Message
			// Updater messages
			UPDATER_RESTART = new Message("Updater.restart", COLOR_WARNING),
			UPDATER_DOWNLOADING = new Message("Updater.downloading", COLOR_INFO),
			UPDATER_BIG_UPDATE = new Message("Updater.bigUpdate", COLOR_WARNING),

			// General command messages
			COMMAND_PLAYERS_ONLY = new Message("Command.justForPlayers", COLOR_ERROR),
			COMMAND_CONSOLE_ONLY = new Message("Command.justForConsole", COLOR_ERROR),
			COMMAND_NO_PERMISSION = new Message("Command.noPermission", COLOR_ERROR),
			COMMAND_INVALID_PLAYER = new Message("Command.invalidPlayer", COLOR_ERROR),
			COMMAND_INVALID_MATERIAL = new Message("Command.invalidMaterial", COLOR_ERROR),
			COMMAND_NOTARGET = new Message("Command.noTarget", COLOR_ERROR),
			COMMAND_DISABLED_IN_WORLD = new Message("Command.disabledInWorld", COLOR_ERROR),
			COMMAND_NO_MORE_CLICK_WAITING = new Message("Command.noMoreClickWaiting", COLOR_INFO),

			// CE_Ignore messages
			COMMAND_IGNORE_SUCCESS = new Message("Command.Ignore.success", COLOR_SUCCESS),

			// CE_Import messages
			COMMAND_IMPORT_START = new Message("Command.Import.start", COLOR_INFO),
			COMMAND_IMPORT_SUCCESS = new Message("Command.Import.success", COLOR_SUCCESS),
					COMMAND_IMPORT_UNAVAILABLE = new Message("Command.Import.unavailable", COLOR_ERROR),

			// CE_ShowOwner messages
			COMMAND_SHOWOWNER_CLICK_ENTITY = new Message("Command.Showowner.clickOnEntity", COLOR_SUCCESS),
			COMMAND_SHOWOWNER_CLICK_BLOCK = new Message("Command.Showowner.clickOnBlock", COLOR_SUCCESS),
			COMMAND_SHOWOWNER_ENTITY_UNOWNED = new Message("Command.Showowner.entityUnowned", COLOR_SUCCESS),
			COMMAND_SHOWOWNER_ENTITY_FOUND = new Message("Command.Showowner.entityOwned", COLOR_SUCCESS),
			COMMAND_SHOWOWNER_BLOCK_UNOWNED = new Message("Command.Showowner.blockUnowned", COLOR_SUCCESS),
			COMMAND_SHOWOWNER_BLOCK_FOUND = new Message("Command.Showowner.blockOwned", COLOR_SUCCESS),

			// CE_Owning messages
			COMMAND_OWNING_SUCCESS = new Message("Command.Owning.success", COLOR_SUCCESS),

			// CE_Own messages
			COMMAND_OWN_BLOCKSUCCESS = new Message("Command.Own.blockSuccess", COLOR_SUCCESS),
			COMMAND_OWN_CLICK_ENTITY = new Message("Command.Own.clickOnEntity", COLOR_SUCCESS),
			COMMAND_OWN_CLICK_BLOCK = new Message("Command.Own.clickOnBlock", COLOR_SUCCESS),
			COMMAND_OWN_ENTITYSUCCESS = new Message("Command.Own.entitySuccess", COLOR_SUCCESS),
			COMMAND_OWN_NOPERMISSIONFOROTHERS = new Message("Command.Own.noPermissionForOthers", COLOR_ERROR),
			COMMAND_OWN_SELECTION_SUCCESS = new Message("Command.Own.Selection.success", COLOR_SUCCESS),
			COMMAND_OWN_SELECTION_NOWORLDEDIT = new Message("Command.Own.Selection.noWorldEdit", COLOR_ERROR),
			COMMAND_OWN_SELECTION_NOSELECTION = new Message("Command.Own.Selection.noSelection", COLOR_ERROR),
			COMMAND_OWN_SELECTION_TOO_BIG = new Message("Command.Own.Selection.tooBig", COLOR_ERROR),

			// CE_Unown messages
			COMMAND_UNOWN_BLOCKSUCCESS = new Message("Command.Unown.blockSuccess", COLOR_SUCCESS),
			COMMAND_UNOWN_CLICK_ENTITY = new Message("Command.Unown.clickOnEntity", COLOR_SUCCESS),
			COMMAND_UNOWN_CLICK_BLOCK = new Message("Command.Unown.clickOnBlock", COLOR_SUCCESS),
			COMMAND_UNOWN_ENTITYSUCCESS = new Message("Command.Unown.entitySuccess", COLOR_SUCCESS),
			COMMAND_UNOWN_FOROTHERS_NOTALLOWED = new Message("Command.Unown.noPermissionForOthers", COLOR_ERROR),
			COMMAND_UNOWN_SELECTION_SUCCESS = new Message("Command.Unown.Selection.success", COLOR_SUCCESS),
			COMMAND_UNOWN_SELECTION_NOWORLDEDIT = new Message("Command.Unown.Selection.noWorldEdit", COLOR_ERROR),
			COMMAND_UNOWN_SELECTION_NOSELECTION = new Message("Command.Unown.Selection.noSelection", COLOR_ERROR),
			COMMAND_UNOWN_SELECTION_TOO_BIG = new Message("Command.Unown.Selection.tooBig", COLOR_ERROR),

			// CE_AddFriend messages
			COMMAND_ADDFRIEND_SUCCESS = new Message("Command.Addfriend.success", COLOR_SUCCESS),

			// CE_RemFriend messages
			COMMAND_REMFRIEND_SUCCESS = new Message("Command.Remfriend.success", COLOR_SUCCESS),

			// CE_Lock messages
			COMMAND_LOCK_SUCCESS = new Message("Command.Lock.success", COLOR_SUCCESS),
			COMMAND_LOCK_CLICK_ENTITY = new Message("Command.Lock.clickOnEntity", COLOR_SUCCESS),
			COMMAND_LOCK_CLICK_BLOCK = new Message("Command.Lock.clickOnBlock", COLOR_SUCCESS),

			// CE_Unlock messages
			COMMAND_UNLOCK_SUCCESS = new Message("Command.Unlock.success", COLOR_SUCCESS),
			COMMAND_UNLOCK_CLICK_ENTITY = new Message("Command.Unlock.clickOnEntity", COLOR_SUCCESS),
			COMMAND_UNLOCK_CLICK_BLOCK = new Message("Command.Unlock.clickOnBlock", COLOR_SUCCESS),

			// CE_Protect messages
			COMMAND_PROTECT_SUCCESS = new Message("Command.Protect.success", COLOR_SUCCESS),
			COMMAND_PROTECT_CLICK_ENTITY = new Message("Command.Protect.clickOnEntity", COLOR_SUCCESS),
			COMMAND_PROTECT_CLICK_BLOCK = new Message("Command.Protect.clickOnBlock", COLOR_SUCCESS),

			// CE_Unprotect messages
			COMMAND_UNPROTECT_SUCCESS = new Message("Command.Unprotect.success", COLOR_SUCCESS),
			COMMAND_UNPROTECT_CLICK_ENTITY = new Message("Command.Unprotect.clickOnEntity", COLOR_SUCCESS),
			COMMAND_UNPROTECT_CLICK_BLOCK = new Message("Command.Unprotect.clickOnBlock", COLOR_SUCCESS),

			// CE_List messages
			COMMAND_LIST_FRIENDS = new Message("Command.List.friendsMessageHead", COLOR_SUCCESS),
			COMMAND_LIST_PROTECTED = new Message("Command.List.protectedMessageHead", COLOR_SUCCESS),
			COMMAND_LIST_LOCKED = new Message("Command.List.lockedMessageHead", COLOR_SUCCESS),
			COMMAND_LIST_EMPTY = new Message("Command.List.empty", COLOR_WARNING),

			// CE_UnprotectPlayer messages
			COMMAND_UNPROTECTPLAYER_SUCCESS = new Message("Command.Unprotectplayer.success", COLOR_SUCCESS),

			// CE_UnownPlayer messages
			COMMAND_UNOWNPLAYER_SUCCESS = new Message("Command.Unownplayer.success", COLOR_SUCCESS);

	private static FileConfiguration messages = null;

	private final String path;
	private final String chatColor;

	private Message(String path, String chatColor) {
		this.path = path;
		this.chatColor = chatColor;
	}

	@Override
	public String toString() {
		return getChatColor(chatColor) + messages.getString(path);
	}

	/**
	 * Gets a custom chat color
	 *
	 * @param colorKey one of the color keys (COLOR_SUCCESS, COLOR_ERROR, etc.)
	 * @return a ChatColor
	 */
	public static ChatColor getChatColor(String colorKey) {
		String path = "Colors." + colorKey;
		ChatColor result;
		try {
			result = ChatColor.valueOf(messages.getString(path));
		} catch (IllegalArgumentException e) {
			try {
				Bukkit.getLogger().log(Level.WARNING, "Couldn't find color " + messages.getString(path) + " falling back to default.", "");
			} catch (NullPointerException ignored) {
			}
			result = ChatColor.valueOf(messages.getDefaults().getString(path));
		}

		return result;
	}

	/**
	 * Needs to be invoked once before any other methods are used.
	 *
	 * @param plugin the plugin
	 * @return true, if successful
	 */
	static synchronized boolean loadMessages(BlockOwn plugin) {
		if (messages == null) {
			messages = YamlConfiguration.loadConfiguration(plugin.getMessageFile());
			try {
				messages.addDefaults(YamlConfiguration.loadConfiguration(new InputStreamReader(plugin.getResource("messages.yml"), "UTF-8")));
			} catch (UnsupportedEncodingException e) {
				plugin.getOutput().printError("Error loading default messages", e);
				return false;
			}
			messages.options().copyDefaults(true);
			try {
				messages.save(plugin.getMessageFile());
				return true;
			} catch (IOException e) {
				plugin.getOutput().printError("Error saving message file", e);
				return false;
			}
		} else {
			return true;
		}
	}
}
