package de.pheasn.blockown;

import java.util.logging.Level;

public class DebugOutput extends DefaultOutput {

	public DebugOutput() {
		super();
		getLogger().setLevel(Level.ALL);
	}

	@Override
	public void printException(Throwable e) {
		getLogger().log(Level.WARNING, "Exception in BlockOwn", e);
	}

	@Override
	public void printException(String message) {
		getLogger().log(Level.WARNING, message);
	}

	@Override
	public void printException(String message, Throwable e) {
		getLogger().log(Level.WARNING, message, e);
	}

}
