package de.pheasn.blockown.importer;

import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.SqliteDatabase;

import java.io.File;
import java.sql.*;
import java.util.UUID;

public class Sqlite extends Importer {

	public Sqlite(Database db, File pluginsFolder, Runnable runnable) {
		super(db, pluginsFolder, runnable);
	}

	@Override
	public void run() {
		if (db instanceof SqliteDatabase) return;
		try {
			Class.forName("org.sqlite.JDBC");
		} catch (ClassNotFoundException e) {
			throw new ImporterException("No sqlite driver found");
		}

		String url = "jdbc:sqlite:" + pluginsFolder.getPath() + "/BlockOwn/world.db";
		Connection con;
		try {
			con = DriverManager.getConnection(url);
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}

		Statement stmnt;
		try {
			stmnt = con.createStatement();
			ResultSet rs = stmnt.executeQuery("SELECT * FROM block_table;");
			while (rs.next()) {
				String worldName = rs.getString("world");
				int x = rs.getInt("x");
				int y = rs.getInt("y");
				int z = rs.getInt("z");
				OwnedBlock block = OwnedBlock.newInstance(worldName, x, y, z);
				if (db.getOwner(block).isNobody()) {
					User owner = User.getInstance(UUID.fromString(rs.getString("player_id")));
					DatabaseAction databaseAction = DatabaseAction.newOwnInstance(block, owner);
					db.enqueue(databaseAction);
				}
			}
			stmnt.close();
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}

		try {
			stmnt = con.createStatement();
			ResultSet rs = stmnt.executeQuery("SELECT * FROM entity_table;");
			while (rs.next()) {
				String worldName = rs.getString("world");
				OwnedEntity entity = OwnedEntity.newInstance(UUID.fromString(rs.getString("entity_id")), worldName);
				if (db.getOwner(entity).isNobody()) {
					User owner = User.getInstance(UUID.fromString(rs.getString("player_id")));
					DatabaseAction databaseAction = DatabaseAction.newOwnInstance(entity, owner);
					db.enqueue(databaseAction);
				}
			}
			stmnt.close();
			con.close();
			finished();
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}
	}

}
