package de.pheasn.blockown.importer;

import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.Setting;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.MySqlDatabase;

import java.io.File;
import java.sql.*;
import java.util.UUID;

public class MySql extends Importer {

	public MySql(Database db, File pluginsFolder, Runnable runnable) {
		super(db, pluginsFolder, runnable);
	}

	@Override
	public void run() {
		if (db instanceof MySqlDatabase) return;
		try {
			Class.forName("com.mysql.jdbc.Driver");
		} catch (ClassNotFoundException e) {
			throw new ImporterException("No mysql driver found");
		}
		String host = Setting.DATABASE_MYSQL_HOST.get().toString();
		int port = Setting.DATABASE_MYSQL_PORT.get();
		String databaseName = Setting.DATABASE_MYSQL_DATABASE.get().toString();
		String username = Setting.DATABASE_MYSQL_USER.get().toString();
		String password = Setting.DATABASE_MYSQL_PASSWORD.get().toString();

		String url;
		if (password.equals("")) {
			url = "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?user="
					+ username + "&autoReconnect=true";
		} else {
			url = "jdbc:mysql://" + host + ":" + port + "/" + databaseName + "?user="
					+ username + "&password=" + password + "&autoReconnect=true";
		}
		Connection con;
		try {
			con = DriverManager.getConnection(url);
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}

		Statement stmnt;
		try {
			stmnt = con.createStatement();
			ResultSet rs = stmnt.executeQuery("SELECT * FROM block_table;");
			while (rs.next()) {
				String worldName = rs.getString("world");
				int x = rs.getInt("x");
				int y = rs.getInt("y");
				int z = rs.getInt("z");
				OwnedBlock block = OwnedBlock.newInstance(worldName, x, y, z);
				if (db.getOwner(block).isNobody()) {
					User owner = User.getInstance(UUID.fromString(rs.getString("player_id")));
					DatabaseAction databaseAction = DatabaseAction.newOwnInstance(block, owner);
					db.enqueue(databaseAction);
				}
			}
			stmnt.close();
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}

		try {
			stmnt = con.createStatement();
			ResultSet rs = stmnt.executeQuery("SELECT * FROM entity_table;");
			while (rs.next()) {
				String worldName = rs.getString("world");
				OwnedEntity entity = OwnedEntity.newInstance(UUID.fromString(rs.getString("entity_id")), worldName);
				if (db.getOwner(entity).isNobody()) {
					User owner = User.getInstance(UUID.fromString(rs.getString("player_id")));
					DatabaseAction databaseAction = DatabaseAction.newOwnInstance(entity, owner);
					db.enqueue(databaseAction);
				}
			}
			stmnt.close();
			con.close();
			finished();
		} catch (SQLException e) {
			throw new ImporterException(e.getMessage());
		}
	}
}
