package de.pheasn.blockown.event;

import de.pheasn.blockown.*;
import de.pheasn.blockown.database.DatabaseAction;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.world.StructureGrowEvent;

public class L_BlockPlace extends Listener {

	public L_BlockPlace(BlockOwn plugin) {
		super(plugin);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockPlace(BlockPlaceEvent event) {
		Player player = event.getPlayer();
		if (plugin.isEnabledInWorld(player.getWorld())) {
			if (player.hasPermission(Permission.OWN_PLACE.toString())) {
				User user = User.getInstance(player.getUniqueId());
				if (!plugin.isOwning(user)) return;
				OwnedBlock block = OwnedBlock.newInstance(event.getBlock());
				try {
					if (plugin.isOwnEnabled(block.getMaterial())) {
						DatabaseAction databaseAction = DatabaseAction.newOwnInstance(block, user);
						plugin.getOwningDatabase().enqueue(databaseAction);
					}
				} catch (InvalidWorldException e) {
					// can't happen, since the OwnedBlock is backed by a bukkit Block
					plugin.getOutput().printError("This should never happen! L_BLOCKPLACE", e);
				}
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onHangingPlace(HangingPlaceEvent event) {
		if (plugin.isEnabledInWorld(event.getBlock().getWorld())) {
			if (event.getPlayer().hasPermission(Permission.OWN_PLACE.toString())) {
				User owner = User.getInstance(event.getPlayer().getUniqueId());
				if (!plugin.isOwning(owner)) return;
				OwnedEntity entity = OwnedEntity.newInstance(event.getEntity());
				try {
					if (plugin.isOwnEnabled(entity.getMaterial())) {
						DatabaseAction databaseAction = DatabaseAction.newOwnInstance(entity, owner);
						plugin.getOwningDatabase().enqueue(databaseAction);
					}
				} catch (InvalidWorldException e) {
	                // can't happen, since the OwnedEntity is backed by a bukkit Entity
	                plugin.getOutput().printError("This should never happen! L_BLOCKPLACE", e);
				}
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockMultiPlace(BlockMultiPlaceEvent event) {
		Player player = event.getPlayer();
		if (plugin.isEnabledInWorld(player.getWorld())) {
			if (player.hasPermission(Permission.OWN_PLACE.toString())) {
				User user = User.getInstance(player.getUniqueId());
				if (!plugin.isOwning(user)) return;
				OwnedBlock block;
				DatabaseAction databaseAction;
				for (BlockState state : event.getReplacedBlockStates()) {
					block = OwnedBlock.newInstance(state.getBlock());
					try {
						if (plugin.isOwnEnabled(block.getMaterial())) {
							databaseAction = DatabaseAction.newOwnInstance(block, user);
							plugin.getOwningDatabase().enqueue(databaseAction);
						}
					} catch (InvalidWorldException e) {
						// can't happen, since the OwnedBlock is backed by a bukkit Block
						plugin.getOutput().printError("This should never happen! L_BLOCKPLACE", e);
					}
				}
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onStructureGrow(StructureGrowEvent event) {
		if (plugin.isEnabledInWorld(event.getWorld())) {
			OwnedBlock block = OwnedBlock.newInstance(event.getLocation().getBlock());
			User owner = plugin.getOwningDatabase().getOwner(block);
			if (owner.isNobody()) return;
			DatabaseAction databaseAction;
			for (BlockState state : event.getBlocks()) {
				block = OwnedBlock.newInstance(state.getBlock());
				databaseAction = DatabaseAction.newOwnInstance(block, owner);
				plugin.getOwningDatabase().enqueue(databaseAction);
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockGrow(BlockGrowEvent event) {
		if (plugin.isEnabledInWorld(event.getBlock().getWorld())) {
			Material m = event.getNewState().getType();
			if (m == Material.SUGAR_CANE_BLOCK || m == Material.CACTUS) {
				Block lowerBlock = event.getBlock().getRelative(BlockFace.DOWN);
				OwnedBlock lowerOwned = OwnedBlock.newInstance(lowerBlock);
				User owner = plugin.getOwningDatabase().getOwner(lowerOwned);
				if (!owner.isNobody()) {
					OwnedBlock owned = OwnedBlock.newInstance(event.getBlock());
					DatabaseAction databaseAction = DatabaseAction.newOwnInstance(owned, owner);
					plugin.getOwningDatabase().enqueue(databaseAction);
				}
			}
		}
	}

	@EventHandler(priority = EventPriority.HIGH, ignoreCancelled = true)
	public void onBlockPlaceNearChest(BlockPlaceEvent event) {
		Player player = event.getPlayer();
		if (plugin.isEnabledInWorld(player.getWorld())) {
			if (event.getBlock().getType() != org.bukkit.Material.CHEST) {
				return;
			}
			User user = User.getInstance(event.getPlayer().getUniqueId());
			Block blockRight = event.getBlock().getRelative(1, 0, 0);
			Block blockLeft = event.getBlock().getRelative(-1, 0, 0);
			Block blockFront = event.getBlock().getRelative(0, 0, 1);
			Block blockBack = event.getBlock().getRelative(0, 0, -1);
			if (blockLeft.getType() == org.bukkit.Material.CHEST) {
				if (invalidPlacement(blockLeft, user)) {
					event.setCancelled(true);
					return;
				}
			}
			if (blockRight.getType() == org.bukkit.Material.CHEST) {
				if (invalidPlacement(blockRight, user)) {
					event.setCancelled(true);
					return;
				}
			}
			if (blockFront.getType() == org.bukkit.Material.CHEST) {
				if (invalidPlacement(blockFront, user)) {
					event.setCancelled(true);
					return;
				}
			}
			if (blockBack.getType() == org.bukkit.Material.CHEST) {
				if (invalidPlacement(blockBack, user)) {
					event.setCancelled(true);
					return;
				}
			}
		}
	}

	private boolean invalidPlacement(Block nativeBlock, User user) {
		OwnedBlock block = OwnedBlock.newInstance(nativeBlock);
		User owner = plugin.getOwningDatabase().getOwner(block);
		if (owner.isNobody()) return false;
		if (owner.equals(user)) return false;
		try {
			boolean result;
			result = plugin.getProtection().isProtected(owner, block.getMaterial()) || plugin.getProtection().isLocked(owner, block.getMaterial());
			return result;
		} catch (InvalidWorldException e) {
			// can't happen, since the OwnedBlock is backed by a bukkit Block
			plugin.getOutput().printError("This should never happen! L_BLOCKPLACE", e);
			return true;
		}
	}
}
