package de.pheasn.blockown.event;

import de.pheasn.blockown.*;
import de.pheasn.blockown.database.DatabaseAction;
import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.*;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakEvent;

import java.util.Iterator;

public class L_BlockBreak extends Listener {

	public L_BlockBreak(BlockOwn plugin) {
		super(plugin);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockBreak(BlockBreakEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = OwnedBlock.newInstance(event.getBlock());
		unown(block);
		for (Block attachedBlock : getAttachedBlocks(event.getBlock())) {
			unown(OwnedBlock.newInstance(attachedBlock));
		}
	}

	/*
	 * Handle blocks that have a block on top which would get dropped if the block breaks
	 */
	@EventHandler(priority = EventPriority.HIGH, ignoreCancelled = true)
	public void onBlockBreakBefore(BlockBreakEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		User user = User.getInstance(event.getPlayer().getUniqueId(), event.getPlayer());
		for (Block block : getAttachedBlocks(event.getBlock())) {
			OwnedBlock owned = OwnedBlock.newInstance(block);
			User owner = plugin.getOwningDatabase().getOwner(owned);
			if (owner.isNobody() || owner.equals(user)) continue;
			try {
				if (!user.hasAccess(owned.getMaterial(), owner)) {
					event.setCancelled(true);
					return;
				}
			} catch (InvalidWorldException e) {
				// can't happen, since the OwnedBlock is backed by a bukkit Block
				plugin.getOutput().printError("This should never happen! L_BLOCKBREAK", e);
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onHangingBreak(HangingBreakEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;

		OwnedEntity entity = OwnedEntity.newInstance(event.getEntity());
		unown(entity);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onDeath(EntityDeathEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
		OwnedEntity entity = OwnedEntity.newInstance(event.getEntity());
		unown(entity);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onPhysics(BlockPhysicsEvent event) {
		if (plugin.isEnabledInWorld(event.getBlock().getWorld())) {
			org.bukkit.Material material = event.getChangedType();

			if (material == org.bukkit.Material.SAND || material == org.bukkit.Material.GRAVEL) {
				OwnedBlock block = OwnedBlock.newInstance(event.getBlock());
				unown(block);
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onFade(BlockFadeEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = OwnedBlock.newInstance(event.getBlock());
		unown(block);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onLeavesDecay(LeavesDecayEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = OwnedBlock.newInstance(event.getBlock());
		unown(block);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockBurn(BlockBurnEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = OwnedBlock.newInstance(event.getBlock());
		unown(block);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockExploded(EntityExplodeEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
		Iterator<Block> iterator = event.blockList().iterator();
		OwnedBlock block;

		while (iterator.hasNext()) {
			block = OwnedBlock.newInstance(iterator.next());
			unown(block);
		}
	}

	private void unown(Ownable ownable) {
		DatabaseAction databaseAction = DatabaseAction.newUnownInstance(ownable);
		plugin.getOwningDatabase().enqueue(databaseAction);
	}
}
