package de.pheasn.blockown.command;

import de.pheasn.blockown.*;
import de.pheasn.blockown.database.DatabaseAction;

import org.bukkit.block.Block;
import org.bukkit.entity.Player;

import java.util.Iterator;

public class UnownRunner implements Runnable {

	private final BlockOwn plugin;
	private final Iterator<Block> region;
	private final User user;
	private final Player player;

	public UnownRunner(BlockOwn plugin, Iterator<Block> region, User user, Player player) {
		this.plugin = plugin;
		this.region = region;
		this.user = user;
		this.player = player;
	}

	@Override
	public void run() {
		Block bukkitBlock;
		OwnedBlock block;
		int ownedCounter = 0;
		while (region.hasNext()) {
			bukkitBlock = region.next();
			block = OwnedBlock.newInstance(bukkitBlock);
			try {
				if (bukkitBlock.getType() != org.bukkit.Material.AIR && plugin.isOwnEnabled(block.getMaterial())) {
					if (plugin.getOwningDatabase().getOwner(block).equals(user) ||
							(player.hasPermission(Permission.ADMIN_UNOWN.toString()) && plugin.isIgnoring(user))) {
						DatabaseAction databaseAction = DatabaseAction.newUnownInstance(block);
						plugin.getOwningDatabase().enqueue(databaseAction);
						ownedCounter++;
					}
				}
			} catch (InvalidWorldException e) {
				// Should never happen, since world name is from bukkit Block instance
				plugin.getOutput().printError("This should never happen! UnownRunner", e);
			}
		}
		plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_SELECTION_SUCCESS, ownedCounter);
	}

}
