package de.pheasn.blockown.command;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.InvalidWorldException;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.DatabaseAction;

import org.bukkit.block.Block;
import org.bukkit.entity.Player;

import java.util.Iterator;

public class OwnRunner implements Runnable {

	private final BlockOwn plugin;
	private final Iterator<Block> region;
	private final User user;
	private final Player player;

	public OwnRunner(BlockOwn plugin, Iterator<Block> region, User user, Player player) {
		this.plugin = plugin;
		this.region = region;
		this.user = user;
		this.player = player;
	}

	@Override
	public void run() {
		Block bukkitBlock;
		OwnedBlock block;
		int ownedCounter = 0;
		while (region.hasNext()) {
			bukkitBlock = region.next();
			block = OwnedBlock.newInstance(bukkitBlock);
			try {
				if (bukkitBlock.getType() != org.bukkit.Material.AIR
						&& plugin.isOwnEnabled(block.getMaterial())) {
					if (plugin.getOwningDatabase().getOwner(block).isNobody()) {
						DatabaseAction databaseAction = DatabaseAction.newOwnInstance(block, user);
						plugin.getOwningDatabase().enqueue(databaseAction);
						ownedCounter++;
					}
				}
			} catch (InvalidWorldException e) {
				// Should never happen, since world name is from bukkit Block instance
				plugin.getOutput().printException("This should never happen! OwnRunner", e);
			}
		}
		plugin.getOutput().sendMessage(player, Message.COMMAND_OWN_SELECTION_SUCCESS, ownedCounter);
	}

}
