package de.pheasn.blockown.command;

import de.pheasn.blockown.*;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import java.util.Set;

public class CE_ShowOwner extends CommandExecutor {

	private static final String PARAM_ENTITY = "e";
	private static final String PARAM_BLOCK = "b";

	public CE_ShowOwner(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	public boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.OWN_SHOWOWNER.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}

		if (!plugin.isEnabledInWorld(player.getWorld())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_DISABLED_IN_WORLD);
			return true;
		}

		if (args.length == 1) {
			if (args[0].equalsIgnoreCase(PARAM_ENTITY)) {
				User user = User.getInstance(player.getUniqueId());
				if (plugin.isWaiting(user, WaitType.SHOW_OWNER_ENTITY)) {
					plugin.removeWaiting(user);
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
				} else {
					plugin.addWaiting(user, WaitType.SHOW_OWNER_ENTITY);
					plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_CLICK_ENTITY);
				}
				return true;
			}
			if (args[0].equalsIgnoreCase(PARAM_BLOCK)) {
				User user = User.getInstance(player.getUniqueId());
				if (plugin.isWaiting(user, WaitType.SHOW_OWNER_BLOCK)) {
					plugin.removeWaiting(user);
					plugin.getOutput().sendMessage(player, Message.COMMAND_NO_MORE_CLICK_WAITING);
				} else {
					plugin.addWaiting(user, WaitType.SHOW_OWNER_BLOCK);
					plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_CLICK_BLOCK);
				}
				return true;
			}
		}

		Block block = player.getTargetBlock((Set<org.bukkit.Material>) null, 20);
		if (block != null) {
			OwnedBlock ownedBlock = OwnedBlock.newInstance(block);
			User owner = plugin.getOwningDatabase().getOwner(ownedBlock);
			try {
				if (owner.isNobody()) {
					plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_BLOCK_UNOWNED, ownedBlock.getMaterial().getName());
				} else {
					plugin.getOutput().sendMessage(player, Message.COMMAND_SHOWOWNER_BLOCK_FOUND, owner.getName(), ownedBlock.getMaterial().getName());
				}
				return true;
			} catch (InvalidWorldException e) {
				// Should never happen
				plugin.getOutput().printException("Exception that shouldn't happen happened in " + getClass().getName(), e);
				return false;
			}
		} else {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NOTARGET);
			return false;
		}

	}
}
