package de.pheasn.blockown.command;

import org.bukkit.command.Command;
import org.bukkit.entity.Player;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;

public class CE_Owning extends CommandExecutor {

	private static final String PARAM_ON = "on";
	private static final String PARAM_OFF = "off";

	public CE_Owning(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		if (!player.hasPermission(Permission.OWN_SWITCH_OWNING.toString())) {
			plugin.getOutput().sendMessage(player, Message.COMMAND_NO_PERMISSION);
			return true;
		}
		User user = User.getInstance(player.getUniqueId());
		boolean turnOn;
		if (args.length == 1) {
			if (args[0].equalsIgnoreCase(PARAM_ON)) {
				turnOn = true;
			} else if (args[0].equalsIgnoreCase(PARAM_OFF)) {
				turnOn = false;
			} else {
				return false;
			}
		} else if (args.length == 0) {
			turnOn = !plugin.isOwning(user);
		} else {
			return false;
		}

		plugin.setOwning(user, turnOn);
		plugin.getOutput().sendMessage(player, Message.COMMAND_OWNING_SUCCESS, turnOn ? "on" : "off");
		return true;
	}

}
