package de.pheasn.blockown;

import de.pheasn.pluginupdater.ReleaseChannel;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

import java.io.File;
import java.io.IOException;
import java.util.List;

public class Setting<T> {

	public static final Setting<Object> VERSION = new Setting<>("version");
	public static final Setting<Boolean> DEBUG_MODE = new Setting<>("debug-mode");
	public static final Setting<List<String>> ENABLED_WORLDS = new Setting<>("enabledWorlds");
	public static final Setting<List<String>> DISABLED_WORLDS = new Setting<>("disabledWorlds");

	public static final Setting<Boolean> UPDATER_ENABLE = new Setting<>("Updater.enable");
	public static final Setting<Object> UPDATER_RELEASE_CHANNEL = new Setting<>("Updater.release-channel");
	public static final Setting<Object> UPDATER_API_KEY = new Setting<>("Updater.apiKey");

	public static final Setting<Boolean> DATABASE_MYSQL_ENABLE = new Setting<>("Database.MySQL.enable");
	public static final Setting<Object> DATABASE_MYSQL_HOST = new Setting<>("Database.MySQL.host");
	public static final Setting<Integer> DATABASE_MYSQL_PORT = new Setting<>("Database.MySQL.port");
	public static final Setting<Object> DATABASE_MYSQL_DATABASE = new Setting<>("Database.MySQL.database");
	public static final Setting<Object> DATABASE_MYSQL_USER = new Setting<>("Database.MySQL.user");
	public static final Setting<Object> DATABASE_MYSQL_PASSWORD = new Setting<>("Database.MySQL.password");

	public static final Setting<Boolean> DATABASE_ALLOW_ENTITIES = new Setting<>("Database.allowEntities");
	public static final Setting<Boolean> DATABASE_ALLOW_ANIMALS = new Setting<>("Database.allowAnimals");
	public static final Setting<List<String>> DATABASE_ALLOWED_MATERIALS = new Setting<>("Database.allowedMaterials");
	public static final Setting<List<String>> DATABASE_DISALLOWED_MATERIALS = new Setting<>("Database.disallowedMaterials");
	public static final Setting<Integer> DATABASE_MAX_SELECTION = new Setting<>("Database.maxSelectionSize");

	public static final Setting<Boolean> PROTECTION_AUTO_PROTECT_OWNED_BLOCKS = new Setting<>("Protection.autoProtectOwnedBlocks");
	public static final Setting<Boolean> PROTECTION_AUTO_PROTECT_OWNED_ENTITIES = new Setting<>("Protection.autoProtectOwnedEntities");
	public static final Setting<Boolean> PROTECTION_AUTO_PROTECT_OWNED_ANIMALS = new Setting<>("Protection.autoProtectOwnedAnimals");
	public static final Setting<List<String>> PROTECTION_AUTO_PROTECT_MATERIALS = new Setting<>("Protection.autoProtectMaterials");
	public static final Setting<List<String>> PROTECTION_ALLOWED_MATERIALS = new Setting<>("Protection.allowedMaterials");
	public static final Setting<List<String>> PROTECTION_DISALLOWED_MATERIALS = new Setting<>("Protection.disallowedMaterials");
	public static final Setting<Boolean> PROTECTION_PROTECT_AGAINST_ENVIRONMENT = new Setting<>("Protection.protectAgainstEnvironment");
	public static final Setting<Boolean> PROTECTION_ALLOW_RIGHT_CLICKS = new Setting<>("Protection.allowRightClicks");

	@Deprecated
	public enum OLD {
		PROTECTION_PROTECT_ONLY_LEFT_CLICKS("3.0.5", new Setting<Boolean>("Protection.onlyLeftClicks"), new Runnable() {
			@Override
			public void run() {
				PROTECTION_ALLOW_RIGHT_CLICKS.set(PROTECTION_PROTECT_ONLY_LEFT_CLICKS.getSetting().get());
			}
		});

		private final String deprecatingVersion;
		private final Setting<?> setting;
		private final Runnable transfer;

		OLD(String deprecatingVersion, Setting<?> setting, Runnable transfer) {
			this.deprecatingVersion = deprecatingVersion;
			this.setting = setting;
			this.transfer = transfer;
		}

		public Setting<?> getSetting() {
			return setting;
		}

		public String getDeprecatingVersion() {
			return deprecatingVersion;
		}

		public void transferValue() {
			transfer.run();
		}
	}

	private static Output output;
	private static FileConfiguration config;
	private static File configFile;

	public static void setOutput(Output output) {
		Setting.output = output;
	}

	/**
	 * Sets the config backing all Settings
	 * @param config the config
	 * @param configFile the file to which changes shall be written
	 */
	public static void setConfig(FileConfiguration config, File configFile) {
		Setting.config = config;
		Setting.configFile = configFile;
	}

	private static Output getOutput() {
		return output;
	}

	private static FileConfiguration getConfig() {
		return config;
	}

	private static File getConfigFile() {
		return configFile;
	}

	private final String path;

	private Setting(String path) {
		this.path = path;
	}

	public T get() {
		try {
			Object o = getConfig().get(path);
			if (o == null) return null;

			@SuppressWarnings("unchecked")
			T t = (T) o;
			return t;
		} catch (ClassCastException e) {
			if (getOutput() != null) getOutput().printException("Setting (path: " + path + ") wasn't available in correct type", e);
			else System.out.println("Setting wasn't available in correct type");
			return null;
		}
	}

	public ReleaseChannel getReleaseChannel() {
		try {
			return ReleaseChannel.valueOf(getConfig().getString(path).toUpperCase());
		} catch (IllegalArgumentException e) {
			getOutput().printException(e);
			return null;
		}
	}

	/**
	 * Changes a setting.
	 *
	 * @param value the new value
	 * @throws NullPointerException if Setting has been initialized with null as config file
	 */
	public void set(Object value) throws NullPointerException {
		if(configFile != null) {
			setConfig(YamlConfiguration.loadConfiguration(configFile), configFile);
		}
		getConfig().set(path, value);

		try{
			getConfig().save(getConfigFile());
		} catch (IOException e) {
			getOutput().printException("Config couldn't be saved", e);
		} catch (NullPointerException e) {
			getOutput().printException("Tried to write through a read-only instance of Setting");
			throw new NullPointerException("Can't set write settings through read-only instance");
		}
	}

	/**
	 * Returns the settings path represented by this Setting
	 */
	@Override
	public String toString() {
		return path;
	}

}
