package de.pheasn.blockown;

import java.util.logging.Logger;

import org.bukkit.World;
import org.bukkit.command.CommandSender;

public interface Output {

	/**
	 * For severe errors Prints info about the throwable to console
	 *
	 * @param e
	 *            the Throwable
	 */
	void printError(Throwable e);

	/**
	 * For severe errors Prints the message to console
	 *
	 * @param message
	 *            the message. Should be user readable
	 */
	void printError(String message);

	/**
	 * For severe errors Prints the message and info about the throwable to console
	 *
	 * @param message
	 *            the message, Should be user readable
	 * @param e
	 *            the Throwable
	 */
	void printError(String message, Throwable e);

	/**
	 * Prints info about the throwable to console.
	 * Details only shown in debug mode
	 *
	 * @param e
	 *            the Throwable
	 */
	void printException(Throwable e);

	/**
	 * Prints the message to console.
	 * Details only shown in debug mode
	 *
	 * @param message
	 *            the message. Should be user readable
	 */
	void printException(String message);

	/**
	 * Prints the message and info about the throwable to console.
	 * Details only shown in debug mode
	 *
	 * @param message
	 *            the message, Should be user readable
	 * @param e
	 *            the Throwable
	 */
	void printException(String message, Throwable e);

	/**
	 * Prints message to console.
	 *
	 * @param message
	 *            the message
	 */
	void printConsole(Message message);

	/**
	 * Prints string message to console.
	 *
	 * @param message
	 *            the message
	 */
	void printConsole(String message);

	/**
	 * Send a message to a CommandSender
	 *
	 * @param sender
	 *            the sender
	 * @param message
	 *            the message
	 */
	void sendMessage(CommandSender sender, Message message);

	/**
	 * Send a CommandSender a message
	 *
	 * @param sender
	 *            the sender
	 * @param message
	 *            the message
	 * @param params
	 *            the parameters
	 */
	void sendMessage(CommandSender sender, Message message, Object... params);

	/**
	 * Broadcast a message on the whole server
	 *
	 * @param message
	 *            the message
	 */
	void broadcast(Message message);

	/**
	 * Broadcast a message in a specific world
	 *
	 * @param world
	 *            the world
	 * @param message
	 *            the message
	 */
	void broadcast(World world, Message message);

	/**
	 * Prints a debug message
	 *
	 * @param message
	 *            the message
	 */
	void debugMessage(String message);

	/**
	 * Gets the plugin's Logger
	 *
	 * @return the Logger
	 */
	Logger getLogger();
}
