/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.event;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.WaitType;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;
import de.pheasn.blockown.event.Listener;
import de.pheasn.blockown.protection.ProtectAction;
import de.pheasn.blockown.protection.ProtectActionType;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockMultiPlaceEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.world.StructureGrowEvent;

public class L_BlockPlace
extends Listener {
    public L_BlockPlace(BlockOwn plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isEnabledInWorld(player.getWorld()) && player.hasPermission(Permission.OWN_PLACE.toString())) {
            User user = new User(player.getUniqueId());
            OwnedBlock block = new OwnedBlock(event.getBlock());
            if (this.plugin.isOwnEnabled(block.getMaterial())) {
                DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, user);
                this.plugin.getOwningDatabase().enqueue(databaseAction);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (this.plugin.isEnabledInWorld(event.getBlock().getWorld()) && event.getPlayer().hasPermission(Permission.OWN_PLACE.toString())) {
            OwnedEntity entity = new OwnedEntity((Entity)event.getEntity());
            User owner = new User(event.getPlayer().getUniqueId());
            if (this.plugin.isOwnEnabled(entity.getMaterial())) {
                DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, entity, owner);
                this.plugin.getOwningDatabase().enqueue(databaseAction);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockMultiPlace(BlockMultiPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isEnabledInWorld(player.getWorld()) && player.hasPermission(Permission.OWN_PLACE.toString())) {
            User user = new User(player.getUniqueId());
            for (BlockState state : event.getReplacedBlockStates()) {
                OwnedBlock block = new OwnedBlock(state.getBlock());
                if (!this.plugin.isOwnEnabled(block.getMaterial())) continue;
                DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, user);
                this.plugin.getOwningDatabase().enqueue(databaseAction);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onStructureGrow(StructureGrowEvent event) {
        if (this.plugin.isEnabledInWorld(event.getWorld())) {
            OwnedBlock block = new OwnedBlock(event.getLocation().getBlock());
            User owner = this.plugin.getOwningDatabase().getOwner(block);
            if (owner.isNobody()) {
                return;
            }
            for (BlockState state : event.getBlocks()) {
                block = new OwnedBlock(state.getBlock());
                DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, owner);
                this.plugin.getOwningDatabase().enqueue(databaseAction);
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockGrow(BlockGrowEvent event) {
        Material m;
        if (this.plugin.isEnabledInWorld(event.getBlock().getWorld()) && ((m = event.getNewState().getType()) == Material.SUGAR_CANE_BLOCK || m == Material.CACTUS)) {
            Block lowerBlock = event.getBlock().getRelative(BlockFace.DOWN);
            OwnedBlock lowerOwned = new OwnedBlock(lowerBlock);
            User owner = this.plugin.getOwningDatabase().getOwner(lowerOwned);
            if (!owner.isNobody()) {
                OwnedBlock owned = new OwnedBlock(event.getBlock());
                DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, owned, owner);
                this.plugin.getOwningDatabase().enqueue(databaseAction);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlaceNearChest(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isEnabledInWorld(player.getWorld())) {
            if (event.getBlock().getType() != Material.CHEST) {
                return;
            }
            User user = new User(event.getPlayer().getUniqueId());
            Block blockRight = event.getBlock().getRelative(1, 0, 0);
            Block blockLeft = event.getBlock().getRelative(-1, 0, 0);
            Block blockFront = event.getBlock().getRelative(0, 0, 1);
            Block blockBack = event.getBlock().getRelative(0, 0, -1);
            if (blockLeft.getType() == Material.CHEST && this.invalidPlacement(blockLeft, user)) {
                event.setCancelled(true);
                return;
            }
            if (blockRight.getType() == Material.CHEST && this.invalidPlacement(blockRight, user)) {
                event.setCancelled(true);
                return;
            }
            if (blockFront.getType() == Material.CHEST && this.invalidPlacement(blockFront, user)) {
                event.setCancelled(true);
                return;
            }
            if (blockBack.getType() == Material.CHEST && this.invalidPlacement(blockBack, user)) {
                event.setCancelled(true);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerChooseEntity(PlayerInteractEntityEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getRightClicked().getWorld())) {
            return;
        }
        User user = new User(event.getPlayer().getUniqueId());
        OwnedEntity entity = new OwnedEntity(event.getRightClicked());
        WaitType waitType = this.plugin.getWaiting(user);
        if (waitType == null) {
            return;
        }
        if (!this.plugin.isOwnEnabled(entity.getMaterial())) {
            return;
        }
        User owner = this.plugin.getOwningDatabase().getOwner(entity);
        Player player = event.getPlayer();
        switch (waitType) {
            case SHOW_OWNER: {
                if (owner.isNobody()) {
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_SHOWOWNER_ENTITY_UNOWNED);
                    break;
                }
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_SHOWOWNER_ENTITY_FOUND, owner.getName());
                break;
            }
            case OWN: {
                if (owner.isNobody()) {
                    DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, entity, user);
                    this.plugin.getOwningDatabase().enqueue(databaseAction);
                    this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_OWN_ENTITYSUCCESS, entity.getMaterial().getName());
                    break;
                }
                this.plugin.getOutput().sendMessage((CommandSender)event.getPlayer(), Message.COMMAND_OWN_NOPERMISSIONFOROTHERS);
                break;
            }
            case UNOWN: {
                if (owner.equals(user) || player.hasPermission(Permission.ADMIN_UNOWN.toString())) {
                    DatabaseAction databaseAction = new DatabaseAction(entity);
                    this.plugin.getOwningDatabase().enqueue(databaseAction);
                    this.plugin.getOutput().sendMessage((CommandSender)event.getPlayer(), Message.COMMAND_UNOWN_ENTITYSUCCESS, entity.getMaterial().getName());
                    break;
                }
                this.plugin.getOutput().sendMessage((CommandSender)event.getPlayer(), Message.COMMAND_UNOWN_FOROTHERS_NOTALLOWED);
                break;
            }
            case PROTECT: {
                ProtectAction protectAction = new ProtectAction(ProtectActionType.PROTECT, user, entity.getMaterial());
                this.plugin.getProtection().enqueue(protectAction);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_PROTECT_SUCCESS, entity.getMaterial().getName());
                break;
            }
            case UNPROTECT: {
                ProtectAction protectAction = new ProtectAction(ProtectActionType.UNPROTECT, user, entity.getMaterial());
                this.plugin.getProtection().enqueue(protectAction);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNPROTECT_SUCCESS, entity.getMaterial().getName());
                break;
            }
            case LOCK: {
                ProtectAction protectAction = new ProtectAction(ProtectActionType.LOCK, user, entity.getMaterial());
                this.plugin.getProtection().enqueue(protectAction);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_LOCK_SUCCESS, entity.getMaterial().getName());
                break;
            }
            case UNLOCK: {
                ProtectAction protectAction = new ProtectAction(ProtectActionType.UNLOCK, user, entity.getMaterial());
                this.plugin.getProtection().enqueue(protectAction);
                this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_UNLOCK_SUCCESS, entity.getMaterial().getName());
                break;
            }
        }
        this.plugin.removeWaiting(user);
    }

    private boolean invalidPlacement(Block nativeBlock, User user) {
        OwnedBlock block = new OwnedBlock(nativeBlock);
        User owner = this.plugin.getOwningDatabase().getOwner(block);
        if (owner.isNobody()) {
            return false;
        }
        if (owner.equals(user)) {
            return false;
        }
        return this.plugin.getProtection().isProtected(owner, block.getMaterial()) || this.plugin.getProtection().isLocked(owner, block.getMaterial());
    }
}

