/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.event;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.event.Listener;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakEvent;

public class L_BlockBreak
extends Listener {
    public L_BlockBreak(BlockOwn plugin) {
        super(plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        OwnedBlock block = new OwnedBlock(event.getBlock());
        this.unown(block);
        for (Block attachedBlock : this.getAttachedBlocks(event.getBlock())) {
            this.unown(new OwnedBlock(attachedBlock));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreakBefore(BlockBreakEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        User user = new User(event.getPlayer().getUniqueId(), (OfflinePlayer)event.getPlayer());
        for (Block block : this.getAttachedBlocks(event.getBlock())) {
            OwnedBlock owned = new OwnedBlock(block);
            User owner = this.plugin.getOwningDatabase().getOwner(owned);
            if (owner.isNobody() || owner.equals(user) || user.hasAccess(owned.getMaterial(), owner)) continue;
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        OwnedEntity entity = new OwnedEntity((Entity)event.getEntity());
        this.unown(entity);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onDeath(EntityDeathEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        OwnedEntity entity = new OwnedEntity((Entity)event.getEntity());
        this.unown(entity);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPhysics(BlockPhysicsEvent event) {
        Material material;
        if (this.plugin.isEnabledInWorld(event.getBlock().getWorld()) && ((material = event.getChangedType()) == Material.SAND || material == Material.GRAVEL)) {
            OwnedBlock block = new OwnedBlock(event.getBlock());
            this.unown(block);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onFade(BlockFadeEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        OwnedBlock block = new OwnedBlock(event.getBlock());
        this.unown(block);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onLeavesDecay(LeavesDecayEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        OwnedBlock block = new OwnedBlock(event.getBlock());
        this.unown(block);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getBlock().getWorld())) {
            return;
        }
        OwnedBlock block = new OwnedBlock(event.getBlock());
        this.unown(block);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockExploded(EntityExplodeEvent event) {
        if (!this.plugin.isEnabledInWorld(event.getEntity().getWorld())) {
            return;
        }
        Iterator iterator = event.blockList().iterator();
        while (iterator.hasNext()) {
            OwnedBlock block = new OwnedBlock((Block)iterator.next());
            this.unown(block);
        }
    }

    private void unown(Ownable ownable) {
        DatabaseAction databaseAction = new DatabaseAction(ownable);
        this.plugin.getOwningDatabase().enqueue(databaseAction);
    }
}

