/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.database.ActionNotPerformedException;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;

class DatabaseOperation
implements Runnable {
    private final DatabaseAction action;
    private final Database database;

    DatabaseOperation(Database database, DatabaseAction action) {
        this.action = action;
        this.database = database;
    }

    @Override
    public void run() {
        if (this.action.getActionType() == DatabaseActionType.DROP) {
            this.database.dropDatabaseUserData(this.action.getUser());
        } else if (!this.database.setDatabaseOwner(this.action)) {
            this.database.getOutput().printException("An action has not been performed", new ActionNotPerformedException(this.action));
        }
    }
}

