/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.DatabaseActionType;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DatabaseAction {
    private final User user;
    private final Ownable ownable;
    private final DatabaseActionType databaseActionType;
    private final long timeStamp;

    public DatabaseAction(DatabaseActionType databaseActionType, Ownable ownable, User user) {
        this.user = user;
        this.ownable = ownable;
        this.databaseActionType = databaseActionType;
        this.timeStamp = System.currentTimeMillis();
    }

    public DatabaseAction(Ownable ownable) {
        this(DatabaseActionType.UNOWN, ownable, null);
    }

    public DatabaseAction(User user) {
        this(DatabaseActionType.DROP, null, user);
    }

    public User getUser() {
        return this.user;
    }

    public Ownable getOwnable() {
        return this.ownable;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public DatabaseActionType getActionType() {
        return this.databaseActionType;
    }

    public int hashCode() {
        int prime = 29;
        int result = 1;
        result = 29 * result + (this.databaseActionType == null ? 0 : this.databaseActionType.hashCode());
        result = 29 * result + (this.ownable == null ? 0 : this.ownable.hashCode());
        result = 29 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        result = 29 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DatabaseAction other = (DatabaseAction)obj;
        if (this.databaseActionType != other.databaseActionType) {
            return false;
        }
        if (this.ownable == null ? other.ownable != null : !this.ownable.equals(other.ownable)) {
            return false;
        }
        if (this.timeStamp != other.timeStamp) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String toString() {
        return "DatabaseAction [user=" + this.user + ", ownable=" + this.ownable + ", databaseActionType=" + (Object)((Object)this.databaseActionType) + ", timeStamp=" + new SimpleDateFormat().format(new Date(this.timeStamp)) + "]";
    }
}

