/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.database;

import de.pheasn.blockown.Output;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.CacheAccessor;
import de.pheasn.blockown.database.CachedDatabaseOperation;
import de.pheasn.blockown.database.Database;
import de.pheasn.blockown.database.DatabaseAction;
import java.io.File;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class CachedDatabase
extends Database {
    final CacheAccessor cache;

    protected CachedDatabase(Output output, File pluginFolder) {
        super(output);
        this.cache = new CacheAccessor(this, pluginFolder);
    }

    @Override
    public User getOwner(Ownable ownable) {
        return this.cache.getOwner(ownable);
    }

    @Override
    public void enqueue(DatabaseAction databaseAction) {
        try {
            this.threadPool.execute(new CachedDatabaseOperation(this, databaseAction));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        while (!this.disable) {
            this.cache.flush();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.threadPool.shutdown();
        this.getOutput().debugMessage("Waiting for database actions termination");
        try {
            this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.cache.flush();
        this.close();
    }
}

