/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.DatabaseAction;
import de.pheasn.blockown.database.DatabaseActionType;
import java.util.Iterator;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class OwnRunner
implements Runnable {
    private final BlockOwn plugin;
    private final Iterator<Block> region;
    private final User user;
    private final Player player;

    public OwnRunner(BlockOwn plugin, Iterator<Block> region, User user, Player player) {
        this.plugin = plugin;
        this.region = region;
        this.user = user;
        this.player = player;
    }

    @Override
    public void run() {
        int ownedCounter = 0;
        while (this.region.hasNext()) {
            Block bukkitBlock = this.region.next();
            OwnedBlock block = new OwnedBlock(bukkitBlock);
            if (bukkitBlock.getType() == Material.AIR || !this.plugin.isOwnEnabled(block.getMaterial()) || !this.plugin.getOwningDatabase().getOwner(block).isNobody()) continue;
            DatabaseAction databaseAction = new DatabaseAction(DatabaseActionType.OWN, block, this.user);
            this.plugin.getOwningDatabase().enqueue(databaseAction);
            ++ownedCounter;
        }
        this.plugin.getOutput().sendMessage((CommandSender)this.player, Message.COMMAND_OWN_SELECTION_SUCCESS, ownedCounter);
    }
}

