/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public abstract class CommandExecutor
implements org.bukkit.command.CommandExecutor {
    protected final BlockOwn plugin;

    public CommandExecutor(BlockOwn plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
        if (sender instanceof Player) {
            return this.performCommand((Player)sender, cmd, cmdName, args);
        }
        this.plugin.getOutput().sendMessage(sender, Message.COMMAND_PLAYERS_ONLY);
        return true;
    }

    protected <T extends Entity> T getTarget(Location eyeLocation, Iterable<T> entities) {
        Entity target = null;
        double threshold = 1.0;
        for (Entity other : entities) {
            Vector n = other.getLocation().toVector().subtract(eyeLocation.getDirection());
            if (!(eyeLocation.getDirection().normalize().crossProduct(n).lengthSquared() < threshold) || !(n.normalize().dot(eyeLocation.getDirection().normalize()) >= 0.0) || target != null && !(target.getLocation().distanceSquared(eyeLocation) > other.getLocation().distanceSquared(eyeLocation))) continue;
            target = other;
        }
        return (T)target;
    }

    protected abstract boolean performCommand(Player var1, Command var2, String var3, String[] var4);
}

