/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown.command;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Material;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.command.CommandExecutor;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CE_List
extends CommandExecutor {
    private static final String PARAM_PROTECTED = "protected";
    private static final String PARAM_FRIENDS = "friends";
    private static final String PARAM_LOCKED = "locked";

    public CE_List(BlockOwn plugin) {
        super(plugin);
    }

    @Override
    protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
        if (!player.hasPermission(Permission.PROTECTION_LIST.toString())) {
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_NO_PERMISSION);
            return true;
        }
        if (args.length == 1) {
            Message messageHead;
            Set<Serializable> list;
            User user = new User(player.getUniqueId());
            if (args[0].equalsIgnoreCase(PARAM_FRIENDS)) {
                list = this.plugin.getProtection().getFriends(user);
                messageHead = Message.COMMAND_LIST_FRIENDS;
            } else if (args[0].equalsIgnoreCase(PARAM_LOCKED)) {
                list = this.plugin.getProtection().getLocks(user);
                messageHead = Message.COMMAND_LIST_LOCKED;
            } else if (args[0].equalsIgnoreCase(PARAM_PROTECTED)) {
                list = this.plugin.getProtection().getProtections(user);
                messageHead = Message.COMMAND_LIST_PROTECTED;
            } else {
                return false;
            }
            this.printList(user, player, messageHead, list);
            return true;
        }
        return false;
    }

    private void printList(User user, Player player, Message messageHead, Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        StringBuilder message = new StringBuilder(100);
        if (!iterator.hasNext()) {
            this.plugin.getOutput().sendMessage((CommandSender)player, Message.COMMAND_LIST_EMPTY);
            return;
        }
        message.append(messageHead).append(System.lineSeparator()).append(ChatColor.AQUA);
        if (collection.contains(Material.ANY)) {
            message.append(Material.ANY.toString()).append(System.lineSeparator());
        } else {
            while (iterator.hasNext()) {
                Object o = iterator.next();
                message.append(o.toString()).append(System.lineSeparator());
            }
        }
        player.sendMessage(message.toString());
    }
}

