/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.BlockOwn;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class Message {
    public static final String COLOR_ERROR = "error";
    public static final String COLOR_WARNING = "warning";
    public static final String COLOR_INFO = "info";
    public static final String COLOR_SUCCESS = "success";
    public static final Message UPDATER_RESTART = new Message("Updater.restart", "warning");
    public static final Message UPDATER_DOWNLOADING = new Message("Updater.downloading", "info");
    public static final Message UPDATER_BIG_UPDATE = new Message("Updater.bigUpdate", "warning");
    public static final Message COMMAND_PLAYERS_ONLY = new Message("Command.justForPlayers", "error");
    public static final Message COMMAND_CONSOLE_ONLY = new Message("Command.justForConsole", "error");
    public static final Message COMMAND_NO_PERMISSION = new Message("Command.noPermission", "error");
    public static final Message COMMAND_INVALID_PLAYER = new Message("Command.invalidPlayer", "error");
    public static final Message COMMAND_INVALID_MATERIAL = new Message("Command.invalidMaterial", "error");
    public static final Message COMMAND_NOTARGET = new Message("Command.noTarget", "error");
    public static final Message COMMAND_DISABLED_IN_WORLD = new Message("Command.disabledInWorld", "error");
    public static final Message COMMAND_NO_MORE_CLICK_WAITING = new Message("Command.noMoreClickWaiting", "info");
    public static final Message COMMAND_IGNORE_SUCCESS = new Message("Command.Ignore.success", "success");
    public static final Message COMMAND_IMPORT_START = new Message("Command.Import.start", "info");
    public static final Message COMMAND_IMPORT_SUCCESS = new Message("Command.Import.success", "success");
    public static final Message COMMAND_SHOWOWNER_CLICK_SOMEWHERE = new Message("Command.Showowner.clickOnEntity", "success");
    public static final Message COMMAND_SHOWOWNER_ENTITY_UNOWNED = new Message("Command.Showowner.entityUnowned", "success");
    public static final Message COMMAND_SHOWOWNER_ENTITY_FOUND = new Message("Command.Showowner.entityOwned", "success");
    public static final Message COMMAND_SHOWOWNER_BLOCK_UNOWNED = new Message("Command.Showowner.blockUnowned", "success");
    public static final Message COMMAND_SHOWOWNER_BLOCK_FOUND = new Message("Command.Showowner.blockOwned", "success");
    public static final Message COMMAND_OWN_BLOCKSUCCESS = new Message("Command.Own.blockSuccess", "success");
    public static final Message COMMAND_OWN_CLICK_SOMEWHERE = new Message("Command.Own.clickOnEntity", "success");
    public static final Message COMMAND_OWN_ENTITYSUCCESS = new Message("Command.Own.entitySuccess", "success");
    public static final Message COMMAND_OWN_NOPERMISSIONFOROTHERS = new Message("Command.Own.noPermissionForOthers", "error");
    public static final Message COMMAND_OWN_SELECTION_SUCCESS = new Message("Command.Own.Selection.success", "success");
    public static final Message COMMAND_OWN_SELECTION_NOWORLDEDIT = new Message("Command.Own.Selection.noWorldEdit", "error");
    public static final Message COMMAND_OWN_SELECTION_NOSELECTION = new Message("Command.Own.Selection.noSelection", "error");
    public static final Message COMMAND_UNOWN_BLOCKSUCCESS = new Message("Command.Unown.blockSuccess", "success");
    public static final Message COMMAND_UNOWN_CLICK_SOMEWHERE = new Message("Command.Unown.clickOnEntity", "success");
    public static final Message COMMAND_UNOWN_ENTITYSUCCESS = new Message("Command.Unown.entitySuccess", "success");
    public static final Message COMMAND_UNOWN_FOROTHERS_NOTALLOWED = new Message("Command.Unown.noPermissionForOthers", "error");
    public static final Message COMMAND_UNOWN_SELECTION_SUCCESS = new Message("Command.Unown.Selection.success", "success");
    public static final Message COMMAND_UNOWN_SELECTION_NOWORLDEDIT = new Message("Command.Unown.Selection.noWorldEdit", "error");
    public static final Message COMMAND_UNOWN_SELECTION_NOSELECTION = new Message("Command.Unown.Selection.noSelection", "error");
    public static final Message COMMAND_ADDFRIEND_SUCCESS = new Message("Command.Addfriend.success", "success");
    public static final Message COMMAND_REMFRIEND_SUCCESS = new Message("Command.Remfriend.success", "success");
    public static final Message COMMAND_LOCK_SUCCESS = new Message("Command.Lock.success", "success");
    public static final Message COMMAND_LOCK_CLICK_SOMEWHERE = new Message("Command.Lock.clickOnEntity", "success");
    public static final Message COMMAND_UNLOCK_SUCCESS = new Message("Command.Unlock.success", "success");
    public static final Message COMMAND_UNLOCK_CLICK_SOMEWHERE = new Message("Command.Unlock.clickOnEntity", "success");
    public static final Message COMMAND_PROTECT_SUCCESS = new Message("Command.Protect.success", "success");
    public static final Message COMMAND_PROTECT_CLICK_SOMEWHERE = new Message("Command.Protect.clickOnEntity", "success");
    public static final Message COMMAND_UNPROTECT_SUCCESS = new Message("Command.Unprotect.success", "success");
    public static final Message COMMAND_UNPROTECT_CLICK_SOMEWHERE = new Message("Command.Unprotect.clickOnEntity", "success");
    public static final Message COMMAND_LIST_FRIENDS = new Message("Command.List.friendsMessageHead", "success");
    public static final Message COMMAND_LIST_PROTECTED = new Message("Command.List.protectedMessageHead", "success");
    public static final Message COMMAND_LIST_LOCKED = new Message("Command.List.lockedMessageHead", "success");
    public static final Message COMMAND_LIST_EMPTY = new Message("Command.List.empty", "warning");
    public static final Message COMMAND_UNPROTECTPLAYER_SUCCESS = new Message("Command.Unprotectplayer.success", "success");
    public static final Message COMMAND_UNOWNPLAYER_SUCCESS = new Message("Command.Unownplayer.success", "success");
    private static FileConfiguration messages = null;
    private final String path;
    private final String chatColor;

    private Message(String path, String chatColor) {
        this.path = path;
        this.chatColor = chatColor;
    }

    public String toString() {
        return Message.getChatColor(this.chatColor) + messages.getString(this.path);
    }

    public static ChatColor getChatColor(String colorKey) {
        ChatColor result;
        String path = "Colors." + colorKey;
        try {
            result = ChatColor.valueOf((String)messages.getString(path));
        }
        catch (IllegalArgumentException e) {
            try {
                Bukkit.getLogger().log(Level.WARNING, "Couldn't find color " + messages.getString(path) + " falling back to default.", "");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            result = ChatColor.valueOf((String)messages.getDefaults().getString(path));
        }
        return result;
    }

    static synchronized boolean loadMessages(BlockOwn plugin) {
        if (messages == null) {
            messages = YamlConfiguration.loadConfiguration((File)plugin.getMessageFile());
            try {
                messages.addDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(plugin.getResource("messages.yml"), "UTF-8")));
            }
            catch (UnsupportedEncodingException e) {
                plugin.getOutput().printException("Error loading default messages", e);
                return false;
            }
            messages.options().copyDefaults(true);
            try {
                messages.save(plugin.getMessageFile());
                return true;
            }
            catch (IOException e) {
                plugin.getOutput().printException("Error saving message file", e);
                return false;
            }
        }
        return true;
    }
}

