/*
 * Decompiled with CFR 0.152.
 */
package de.pheasn.blockown;

import de.pheasn.blockown.Message;
import de.pheasn.blockown.Output;
import java.text.MessageFormat;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class DefaultOutput
implements Output {
    private static final String pluginName = "[BlockOwn] ";
    private final ConsoleCommandSender console = Bukkit.getServer().getConsoleSender();

    DefaultOutput() {
    }

    @Override
    public void printException(Exception e) {
        this.printConsole(Message.getChatColor("error") + "An exception occurred.");
    }

    @Override
    public void printException(String message) {
        this.printConsole(Message.getChatColor("error") + message);
    }

    @Override
    public void printException(String message, Exception e) {
        this.printException(Message.getChatColor("error") + message);
    }

    @Override
    public void printConsole(Message message) {
        this.console.sendMessage(pluginName + message.toString());
    }

    @Override
    public void printConsole(String message) {
        this.console.sendMessage(pluginName + message);
    }

    @Override
    public void sendMessage(CommandSender sender, Message message) {
        if (message.toString().isEmpty()) {
            return;
        }
        if (sender instanceof Player) {
            sender.sendMessage(message.toString());
        } else {
            this.printConsole(message);
        }
    }

    @Override
    public void sendMessage(CommandSender sender, Message message, Object ... params) {
        if (message.toString().isEmpty()) {
            return;
        }
        String messageString = MessageFormat.format(message.toString(), params);
        if (sender instanceof Player) {
            sender.sendMessage(messageString);
        } else {
            this.printConsole(messageString);
        }
    }

    @Override
    public void broadcast(Message message) {
        this.printConsole(message);
        for (World world : Bukkit.getServer().getWorlds()) {
            this.broadcastInWorld(world, message);
        }
    }

    @Override
    public void broadcast(World world, Message message) {
        this.printConsole(message);
        this.broadcastInWorld(world, message);
    }

    private void broadcastInWorld(World world, Message message) {
        for (Player player : world.getPlayers()) {
            player.sendMessage(message.toString());
        }
    }

    @Override
    public void debugMessage(String message) {
    }
}

