package de.pheasn.blockown.event;

import java.util.ArrayList;
import java.util.Collection;

import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.material.Attachable;
import org.bukkit.material.Door;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Redstone;

import de.pheasn.blockown.BlockOwn;

@SuppressWarnings("deprecation")
public abstract class Listener implements org.bukkit.event.Listener {

	protected static final BlockFace[] BLOCK_FACES = new BlockFace[] {
			BlockFace.UP,
			BlockFace.NORTH,
			BlockFace.SOUTH,
			BlockFace.WEST,
			BlockFace.EAST };

	protected final BlockOwn plugin;

	public Listener(BlockOwn plugin) {
		this.plugin = plugin;
	}

	protected Collection<Block> getAttachedBlocks(Block block) {
		ArrayList<Block> result = new ArrayList<Block>(5);
		for (BlockFace face : BLOCK_FACES) {
			Block possible = block.getRelative(face);
			MaterialData data = possible.getState().getData();
			if (data instanceof Attachable) {
				Attachable attach = (Attachable) data;
				if (attach.getAttachedFace().getOppositeFace().equals(face)) {
					result.add(possible);
				}
			}
		}

		// Check for top blocks that would drop if the block breaks
		Block topBlock = block.getRelative(BlockFace.UP);
		Block topTopBlock = topBlock.getRelative(BlockFace.UP);
		if (topBlock.getState().getData() instanceof Door && topTopBlock.getState().getData() instanceof Door) {
			result.add(topBlock);
			result.add(topTopBlock);
		}
		if (topBlock.getState().getData() instanceof Redstone && !(topBlock.getState().getData() instanceof Attachable)) {
			result.add(topBlock);
		}

		return result;
	}
}
