package de.pheasn.blockown.event;

import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.Setting;
import de.pheasn.blockown.User;

public class L_PlayerInteractEvent extends Listener {

	public L_PlayerInteractEvent(BlockOwn plugin) {
		super(plugin);
	}

	@EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
	public void onPlayerBlockInteract(PlayerInteractEvent event) {
		Block block = event.getClickedBlock();
		if (block == null) return;

		if (block.getType() == org.bukkit.Material.AIR) {
			return;
		}

		if (Setting.PROTECTION_ALLOW_RIGHT_CLICKS.get() && event.getAction().equals(Action.RIGHT_CLICK_BLOCK)) {
			return;
		}

		if (!plugin.isEnabledInWorld(event.getClickedBlock().getWorld())) return;

		User user = new User(event.getPlayer().getUniqueId());
		if (plugin.isIgnoring(user)) return;
		OwnedBlock ownedBlock = new OwnedBlock(block);
		if (!valid(ownedBlock, user)) {
			event.setCancelled(true);
		}
	}

	@EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
	public void onPlayerEntityInteract(PlayerInteractEntityEvent event) {
		if (Setting.PROTECTION_ALLOW_RIGHT_CLICKS.get()) {
			return;
		}

		if (!plugin.isEnabledInWorld(event.getRightClicked().getWorld())) return;

		User user = new User(event.getPlayer().getUniqueId());
		if (plugin.isIgnoring(user)) return;
		OwnedEntity entity = new OwnedEntity(event.getRightClicked());
		if (!valid(entity, user)) {
			event.setCancelled(true);
		}
	}

	@EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
	public void onPlayerDamageEntity(EntityDamageByEntityEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
		if (event.getDamager() instanceof Player) {
			Player player = (Player) event.getDamager();
			User user = new User(player.getUniqueId());
			if (plugin.isIgnoring(user)) return;
			OwnedEntity entity = new OwnedEntity(event.getEntity());
			if (!valid(entity, user)) {
				event.setCancelled(true);
			}
		}
	}

	@EventHandler(priority = EventPriority.LOWEST, ignoreCancelled = true)
	public void onPlayerBreakHanging(HangingBreakByEntityEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
		if (event.getRemover() instanceof Player) {
			Player player = (Player) event.getRemover();
			User user = new User(player.getUniqueId());
			if (plugin.isIgnoring(user)) return;
			OwnedEntity entity = new OwnedEntity(event.getEntity());
			if (!valid(entity, user)) {
				event.setCancelled(true);
			}
		}
	}

	private boolean valid(Ownable ownable, User user) {
		User owner = plugin.getOwningDatabase().getOwner(ownable);
		if (owner.isNobody()) return true;
		if (owner.equals(user)) return true;
		if (user.hasAccess(ownable)) return true;
		return false;
	}
}
