package de.pheasn.blockown.event;

import java.util.Iterator;

import org.bukkit.block.Block;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.hanging.HangingBreakEvent;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Ownable;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.OwnedEntity;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.DatabaseAction;

public class L_BlockBreak extends Listener {

	public L_BlockBreak(BlockOwn plugin) {
		super(plugin);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockBreak(BlockBreakEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = new OwnedBlock(event.getBlock());
		unown(block);
		for(Block attachedBlock : getAttachedBlocks(event.getBlock())) {
			unown(new OwnedBlock(attachedBlock));
		}
	}

	/**
	 * Handle blocks that have a block on top which would get dropped if the block breaks
	 * 
	 * @param event
	 */
	@EventHandler(priority = EventPriority.HIGH, ignoreCancelled = true)
	public void onBlockBreakBefore(BlockBreakEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		User user = new User(event.getPlayer().getUniqueId(), event.getPlayer());
		for(Block block : getAttachedBlocks(event.getBlock())) {
			OwnedBlock owned = new OwnedBlock(block);
			User owner = plugin.getOwningDatabase().getOwner(owned);
			if(owner.isNobody() || owner.equals(user)) continue;
			if (!user.hasAccess(owned.getMaterial(), owner)) {
				event.setCancelled(true);
				return;
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onHangingBreak(HangingBreakEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;

		OwnedEntity entity = new OwnedEntity(event.getEntity());
		unown(entity);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onDeath(EntityDeathEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
		OwnedEntity entity = new OwnedEntity(event.getEntity());
		unown(entity);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onPhysics(BlockPhysicsEvent event) {
		if (plugin.isEnabledInWorld(event.getBlock().getWorld())) {
			org.bukkit.Material material = event.getChangedType();

			if (material == org.bukkit.Material.SAND || material == org.bukkit.Material.GRAVEL) {
				OwnedBlock block = new OwnedBlock(event.getBlock());
				unown(block);
			}
		}
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onFade(BlockFadeEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = new OwnedBlock(event.getBlock());
		unown(block);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onLeavesDecay(LeavesDecayEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = new OwnedBlock(event.getBlock());
		unown(block);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockBurn(BlockBurnEvent event) {
		if (!plugin.isEnabledInWorld(event.getBlock().getWorld())) return;
		OwnedBlock block = new OwnedBlock(event.getBlock());
		unown(block);
	}

	@EventHandler(priority = EventPriority.MONITOR, ignoreCancelled = true)
	public void onBlockExploded(EntityExplodeEvent event) {
		if (!plugin.isEnabledInWorld(event.getEntity().getWorld())) return;
		Iterator<Block> iterator = event.blockList().iterator();
		OwnedBlock block;

		while (iterator.hasNext()) {
			block = new OwnedBlock(iterator.next());
			unown(block);
		}
	}

	private void unown(Ownable ownable) {
		DatabaseAction databaseAction = new DatabaseAction(ownable);
		plugin.getOwningDatabase().enqueue(databaseAction);
	}
}
