package de.pheasn.blockown.command;

import java.util.Iterator;

import org.bukkit.block.Block;
import org.bukkit.entity.Player;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.OwnedBlock;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.database.DatabaseAction;

public class UnownRunner implements Runnable {

	private final BlockOwn plugin;
	private final Iterator<Block> region;
	private final User user;
	private final Player player;

	public UnownRunner(BlockOwn plugin, Iterator<Block> region, User user, Player player) {
		this.plugin = plugin;
		this.region = region;
		this.user = user;
		this.player = player;
	}

	@Override
	public void run() {
		Block bukkitBlock;
		OwnedBlock block;
		int ownedCounter = 0;
		while (region.hasNext()) {
			bukkitBlock = region.next();
			block = new OwnedBlock(bukkitBlock);
			if (bukkitBlock.getType() != org.bukkit.Material.AIR && plugin.isOwnEnabled(block.getMaterial())) {
				if (plugin.getOwningDatabase().getOwner(block).equals(user) ||
						(player.hasPermission(Permission.ADMIN_UNOWN.toString()) && plugin.isIgnoring(user))) {
					DatabaseAction databaseAction = new DatabaseAction(block);
					plugin.getOwningDatabase().enqueue(databaseAction);
					ownedCounter++;
				}
			}
		}
		plugin.getOutput().sendMessage(player, Message.COMMAND_UNOWN_SELECTION_SUCCESS, ownedCounter);
	}

}
