package de.pheasn.blockown.command;

import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

import de.pheasn.blockown.BlockOwn;
import de.pheasn.blockown.Message;
import de.pheasn.blockown.Permission;
import de.pheasn.blockown.User;
import de.pheasn.blockown.protection.ProtectAction;
import de.pheasn.blockown.protection.ProtectActionType;

public class CE_UnprotectPlayer extends CommandExecutor {

	public CE_UnprotectPlayer(BlockOwn plugin) {
		super(plugin);
	}

	@Override
	public boolean onCommand(CommandSender sender, Command cmd, String cmdName, String[] args) {
		if (!sender.hasPermission(Permission.ADMIN_UNPROTECTPLAYER.toString())) {
			plugin.getOutput().sendMessage(sender, Message.COMMAND_NO_PERMISSION);
			return true;
		}
		if (args.length == 1) {
			@SuppressWarnings("deprecation")
			OfflinePlayer op = plugin.getServer().getOfflinePlayer(args[0]);
			if (op.hasPlayedBefore()) {
				User user = new User(op.getUniqueId());
				ProtectAction protectAction = new ProtectAction(ProtectActionType.DROP, user);
				plugin.getProtection().enqueue(protectAction);
				plugin.getOutput().sendMessage(sender, Message.COMMAND_UNPROTECTPLAYER_SUCCESS, op.getName());
				return true;
			} else {
				plugin.getOutput().sendMessage(sender, Message.COMMAND_INVALID_PLAYER, args[0]);
				return false;
			}
		} else {
			return false;
		}
	}

	@Override
	protected boolean performCommand(Player player, Command cmd, String cmdName, String[] args) {
		return false;
	}

}
